/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.registry.tool;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.bee.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.BlockContext;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.IMatcherFactory;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ItemMatcherFactory;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ItemTagMatcher;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.ModMatcher;
import net.p3pp3rf1y.sophisticatedbackpacks.registry.tool.TypedMatcherFactory;

public class Matchers {
    private static final List<ItemMatcherFactory> ITEM_MATCHER_FACTORIES = new ArrayList<ItemMatcherFactory>();
    private static final List<IMatcherFactory<BlockContext>> BLOCK_MATCHER_FACTORIES = new ArrayList<IMatcherFactory<BlockContext>>();
    private static final List<IMatcherFactory<Entity>> ENTITY_MATCHER_FACTORIES = new ArrayList<IMatcherFactory<Entity>>();

    private Matchers() {
    }

    static void addItemMatcherFactory(ItemMatcherFactory matcherFactory) {
        ITEM_MATCHER_FACTORIES.add(matcherFactory);
    }

    public static Optional<Predicate<ItemStack>> getItemMatcher(JsonElement jsonElement) {
        for (ItemMatcherFactory itemMatcherFactory : ITEM_MATCHER_FACTORIES) {
            if (!itemMatcherFactory.appliesTo(jsonElement)) continue;
            return itemMatcherFactory.getPredicate(jsonElement);
        }
        return Optional.empty();
    }

    public static List<IMatcherFactory<BlockContext>> getBlockMatcherFactories() {
        return BLOCK_MATCHER_FACTORIES;
    }

    public static List<IMatcherFactory<Entity>> getEntityMatcherFactories() {
        return ENTITY_MATCHER_FACTORIES;
    }

    static {
        Matchers.addItemMatcherFactory(new ItemMatcherFactory("tag"){

            @Override
            protected Optional<Predicate<ItemStack>> getPredicateFromObject(JsonObject jsonObject) {
                String tagName = GsonHelper.getAsString((JsonObject)jsonObject, (String)"tag");
                TagKey tag = TagKey.create((ResourceKey)Registries.ITEM, (Identifier)Identifier.parse((String)tagName));
                return Optional.of(new ItemTagMatcher((TagKey<Item>)tag));
            }
        });
        Matchers.addItemMatcherFactory(new ItemMatcherFactory("nocomponents"){

            @Override
            protected Optional<Predicate<ItemStack>> getPredicateFromObject(JsonObject jsonObject) {
                Identifier itemName = Identifier.parse((String)GsonHelper.getAsString((JsonObject)jsonObject, (String)"item"));
                if (!BuiltInRegistries.ITEM.containsKey(itemName)) {
                    SophisticatedBackpacks.LOGGER.debug("{} isn't loaded in item registry, skipping ...", (Object)itemName);
                }
                Item item = (Item)BuiltInRegistries.ITEM.getValue(itemName);
                return Optional.of(st -> st.getItem() == item && st.getComponents().isEmpty());
            }
        });
        BLOCK_MATCHER_FACTORIES.add(new IMatcherFactory<BlockContext>(){

            @Override
            public boolean appliesTo(JsonElement jsonElement) {
                return jsonElement.isJsonPrimitive();
            }

            @Override
            public Optional<Predicate<BlockContext>> getPredicate(JsonElement jsonElement) {
                String modId = jsonElement.getAsString();
                if (!ModList.get().isLoaded(modId)) {
                    SophisticatedBackpacks.LOGGER.debug("{} mod isn't loaded, skipping ...", (Object)modId);
                    return Optional.empty();
                }
                return Optional.of(new ModMatcher<Block, DefaultedRegistry, BlockContext>(BuiltInRegistries.BLOCK, modId, BlockContext::getBlock));
            }
        });
        BLOCK_MATCHER_FACTORIES.add((IMatcherFactory<BlockContext>)new TypedMatcherFactory<BlockContext>("all"){

            @Override
            protected Optional<Predicate<BlockContext>> getPredicateFromObject(JsonObject jsonObject) {
                return Optional.of(block -> true);
            }
        });
        BLOCK_MATCHER_FACTORIES.add((IMatcherFactory<BlockContext>)new TypedMatcherFactory<BlockContext>("rail"){

            @Override
            protected Optional<Predicate<BlockContext>> getPredicateFromObject(JsonObject jsonObject) {
                return Optional.of(blockContext -> blockContext.getBlock() instanceof BaseRailBlock);
            }
        });
        BLOCK_MATCHER_FACTORIES.add((IMatcherFactory<BlockContext>)new TypedMatcherFactory<BlockContext>("item_handler"){

            @Override
            protected Optional<Predicate<BlockContext>> getPredicateFromObject(JsonObject jsonObject) {
                return Optional.of(blockContext -> blockContext.getLevel().getCapability(Capabilities.Item.BLOCK, blockContext.getPos(), null) != null);
            }
        });
        ENTITY_MATCHER_FACTORIES.add((IMatcherFactory<Entity>)new TypedMatcherFactory<Entity>("animal"){

            @Override
            protected Optional<Predicate<Entity>> getPredicateFromObject(JsonObject jsonObject) {
                return Optional.of(Animal.class::isInstance);
            }
        });
        ENTITY_MATCHER_FACTORIES.add((IMatcherFactory<Entity>)new TypedMatcherFactory<Entity>("living"){

            @Override
            protected Optional<Predicate<Entity>> getPredicateFromObject(JsonObject jsonObject) {
                return Optional.of(LivingEntity.class::isInstance);
            }
        });
        ENTITY_MATCHER_FACTORIES.add((IMatcherFactory<Entity>)new TypedMatcherFactory<Entity>("bee"){

            @Override
            protected Optional<Predicate<Entity>> getPredicateFromObject(JsonObject jsonObject) {
                return Optional.of(Bee.class::isInstance);
            }
        });
        ENTITY_MATCHER_FACTORIES.add((IMatcherFactory<Entity>)new TypedMatcherFactory<Entity>("tameable"){

            @Override
            protected Optional<Predicate<Entity>> getPredicateFromObject(JsonObject jsonObject) {
                return Optional.of(TamableAnimal.class::isInstance);
            }
        });
    }
}

