/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedcore.client.render.ClientStorageContentsTooltipBase;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;

public record BackpackSettingsPayload(UUID backpackUuid, ContainerContents.SettingsData settingsData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BackpackSettingsPayload> TYPE = new CustomPacketPayload.Type(SophisticatedBackpacks.getIdentifier("backpack_settings"));
    public static final StreamCodec<RegistryFriendlyByteBuf, BackpackSettingsPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, BackpackSettingsPayload::backpackUuid, (StreamCodec)ContainerContents.SettingsData.STREAM_CODEC, BackpackSettingsPayload::settingsData, BackpackSettingsPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(BackpackSettingsPayload payload, IPayloadContext context) {
        if (payload.settingsData == null) {
            return;
        }
        BackpackStorage backpackStorage = BackpackStorage.get();
        ContainerContents contents = backpackStorage.getOrCreateBackpackContents(payload.backpackUuid);
        backpackStorage.setBackpackContents(payload.backpackUuid, new ContainerContents(contents.inventory(), contents.partitioner(), contents.upgrades(), payload.settingsData));
        ClientStorageContentsTooltipBase.refreshContents();
    }
}

