/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TriState;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMobGriefingEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IAttackEntityResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBlockClickResponseUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlock;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackBlockEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackTranslationHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.EntityBackpackAdditionHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModPayloads;
import net.p3pp3rf1y.sophisticatedbackpacks.network.AnotherPlayerBackpackOpenPayload;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.everlasting.EverlastingBackpackItemEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedcore.network.SyncPlayerSettingsPayload;
import net.p3pp3rf1y.sophisticatedcore.settings.main.PlayerMainSettingsSavedData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.infinity.InfinityUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;

public class CommonEventHandler {
    private static final int BACKPACK_CHECK_COOLDOWN = 40;
    private final Map<Identifier, Long> nextBackpackCheckTime = new HashMap<Identifier, Long>();

    public void registerHandlers(IEventBus modBus) {
        ModItems.registerHandlers(modBus);
        ModBlocks.registerHandlers(modBus);
        modBus.addListener(ModPayloads::registerPayloads);
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(this::onItemPickup);
        eventBus.addListener(this::onLivingSpecialSpawn);
        eventBus.addListener(this::onLivingDrops);
        eventBus.addListener(this::onEntityMobGriefing);
        eventBus.addListener(this::onEntityLeaveWorld);
        eventBus.addListener(this::onBlockClick);
        eventBus.addListener(this::onAttackEntity);
        eventBus.addListener(EntityBackpackAdditionHandler::onLivingUpdate);
        eventBus.addListener(this::onPlayerChangedDimension);
        eventBus.addListener(this::onPlayerRespawn);
        eventBus.addListener(this::onWorldTick);
        eventBus.addListener(this::interactWithEntity);
        eventBus.addListener(this::handleBreakBackpackWithInfinityUpgrade);
        eventBus.addListener(this::handleEverlastingInvulnerability);
    }

    private void interactWithEntity(PlayerInteractEvent.EntityInteractSpecific event) {
        boolean isPointingAtBack;
        Player targetPlayer;
        block6: {
            block5: {
                Entity entity = event.getTarget();
                if (!(entity instanceof Player)) break block5;
                targetPlayer = (Player)entity;
                if (((Boolean)Config.SERVER.allowOpeningOtherPlayerBackpacks.get()).booleanValue()) break block6;
            }
            return;
        }
        Player sourcePlayer = event.getEntity();
        Vec3 targetPlayerViewVector = Vec3.directionFromRotation((Vec2)new Vec2(targetPlayer.getXRot(), targetPlayer.yBodyRot));
        Vec3 hitVector = event.getLocalPos();
        Vec3 vec31 = sourcePlayer.position().vectorTo(targetPlayer.position()).normalize();
        vec31 = new Vec3(vec31.x, 0.0, vec31.z);
        boolean isPointingAtBody = hitVector.y >= 0.9 && hitVector.y < 1.6;
        boolean bl = isPointingAtBack = vec31.dot(targetPlayerViewVector) > 0.0;
        if (!isPointingAtBody || !isPointingAtBack) {
            return;
        }
        if (targetPlayer.level().isClientSide()) {
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new AnotherPlayerBackpackOpenPayload(targetPlayer.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void handleEverlastingInvulnerability(EntityInvulnerabilityCheckEvent event) {
        if (event.getEntity() instanceof EverlastingBackpackItemEntity) {
            event.setInvulnerable(true);
        }
    }

    private void onWorldTick(LevelTickEvent.Post event) {
        boolean runDedupeLogic;
        if (event.getLevel().isClientSide()) {
            return;
        }
        Identifier dimensionKey = event.getLevel().dimension().identifier();
        boolean runSlownessLogic = (Boolean)Config.SERVER.nerfsConfig.tooManyBackpacksSlowness.get();
        boolean bl = runDedupeLogic = (Boolean)Config.SERVER.tickDedupeLogicDisabled.get() == false;
        if (!runSlownessLogic && !runDedupeLogic || this.nextBackpackCheckTime.getOrDefault(dimensionKey, 0L) > event.getLevel().getGameTime()) {
            return;
        }
        this.nextBackpackCheckTime.put(dimensionKey, event.getLevel().getGameTime() + 40L);
        HashMap backpackIds = new HashMap();
        event.getLevel().players().forEach(player -> {
            AtomicInteger numberOfBackpacks = new AtomicInteger(0);
            PlayerInventoryProvider.get().runOnBackpacks((Player)player, (backpack, handlerName, identifier, slot) -> {
                if (runSlownessLogic) {
                    numberOfBackpacks.incrementAndGet();
                }
                if (runDedupeLogic) {
                    CommonEventHandler.addBackpackIdIfUniqueOrDedupe(backpackIds, BackpackWrapper.fromStack(backpack));
                }
                return false;
            });
            if (runSlownessLogic) {
                int maxNumberOfBackpacks = (Integer)Config.SERVER.nerfsConfig.maxNumberOfBackpacks.get();
                if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                    int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((double)(numberOfBackpacks.get() - maxNumberOfBackpacks) * (Double)Config.SERVER.nerfsConfig.slownessLevelsPerAdditionalBackpack.get()));
                    Holder<MobEffect> effect = Config.SERVER.nerfsConfig.getEffect(event.getLevel().registryAccess());
                    player.addEffect(new MobEffectInstance(effect, 80, numberOfSlownessLevels - 1, false, false));
                }
            }
        });
    }

    private static void addBackpackIdIfUniqueOrDedupe(Map<UUID, ItemStack> backpackIds, IBackpackWrapper backpackWrapper) {
        backpackWrapper.getContentsUuid().ifPresent(backpackId -> {
            if (backpackIds.containsKey(backpackId) && backpackIds.get(backpackId) != backpackWrapper.getBackpack()) {
                backpackWrapper.removeContentsUUIDTag();
                backpackWrapper.onContentsUpdated();
            } else {
                backpackIds.put((UUID)backpackId, backpackWrapper.getBackpack());
            }
        });
    }

    private void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.sendPlayerSettingsToClient(event.getEntity());
    }

    private void sendPlayerSettingsToClient(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            String name = "sophisticatedbackpacks";
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncPlayerSettingsPayload(name, PlayerMainSettingsSavedData.get().get(player.getUUID(), name)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.sendPlayerSettingsToClient(event.getEntity());
    }

    private void onBlockClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> {
            IBackpackWrapper wrapper = BackpackWrapper.fromStack(backpack);
            for (IBlockClickResponseUpgrade upgrade : wrapper.getUpgradeHandler().getWrappersThatImplement(IBlockClickResponseUpgrade.class)) {
                if (!upgrade.onBlockClick(player, pos)) continue;
                return true;
            }
            return false;
        });
    }

    private void onAttackEntity(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> {
            IBackpackWrapper wrapper = BackpackWrapper.fromStack(backpack);
            for (IAttackEntityResponseUpgrade upgrade : wrapper.getUpgradeHandler().getWrappersThatImplement(IAttackEntityResponseUpgrade.class)) {
                if (!upgrade.onAttackEntity(player)) continue;
                return true;
            }
            return false;
        });
    }

    private void onLivingSpecialSpawn(FinalizeSpawnEvent event) {
        Monster monster;
        Mob entity = event.getEntity();
        if (entity instanceof Monster && (monster = (Monster)entity).getItemBySlot(EquipmentSlot.CHEST).isEmpty()) {
            EntityBackpackAdditionHandler.addBackpack(monster, event.getLevel());
        }
    }

    private void onLivingDrops(LivingDropsEvent event) {
        EntityBackpackAdditionHandler.handleBackpackDrop(event);
    }

    private void onEntityMobGriefing(EntityMobGriefingEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            EntityBackpackAdditionHandler.removeBeneficialEffects(creeper);
        }
    }

    private void onEntityLeaveWorld(EntityLeaveLevelEvent event) {
        if (!(event.getEntity() instanceof Monster)) {
            return;
        }
        EntityBackpackAdditionHandler.removeBackpackUuid((Monster)event.getEntity(), event.getLevel());
    }

    private void onItemPickup(ItemEntityPickupEvent.Pre event) {
        ItemEntity itemEntity = event.getItemEntity();
        ItemStack stack = itemEntity.getItem();
        if (stack.isEmpty() || itemEntity.pickupDelay > 0) {
            return;
        }
        Player player = event.getPlayer();
        Level level = player.level();
        AtomicInteger remainingCount = new AtomicInteger(stack.getCount());
        try (Transaction tx = Transaction.openRoot();){
            ItemResource resource = ItemResource.of((ItemStack)stack);
            PlayerInventoryProvider.get().runOnBackpacks(player, (backpack, inventoryHandlerName, identifier, slot) -> {
                IBackpackWrapper wrapper = BackpackWrapper.fromStack(backpack);
                int pickedUpCount = InventoryHelper.runPickupOnPickupResponseUpgrades((Level)level, (UpgradeHandler)wrapper.getUpgradeHandler(), (ItemResource)resource, (int)remainingCount.get(), (TransactionContext)tx);
                remainingCount.addAndGet(-pickedUpCount);
                if (pickedUpCount > 0) {
                    CommonEventHandler.playPickupSound(level, player);
                    player.awardStat(Stats.ITEM_PICKED_UP.get((Object)stack.getItem()), pickedUpCount);
                }
                return remainingCount.get() <= 0;
            }, (Boolean)Config.SERVER.nerfsConfig.onlyWornBackpackTriggersUpgrades.get());
            if (remainingCount.get() < stack.getCount()) {
                tx.commit();
                itemEntity.setItem(resource.toStack(remainingCount.get()));
                event.setCanPickup(TriState.FALSE);
            }
        }
    }

    private static void playPickupSound(Level level, Player player) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, RandHelper.getRandomMinusOneToOne((RandomSource)level.random) * 1.4f + 2.0f);
    }

    private void handleBreakBackpackWithInfinityUpgrade(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(event.getState().getBlock() instanceof BackpackBlock)) {
            return;
        }
        if (WorldHelper.getBlockEntity((BlockGetter)event.getLevel(), (BlockPos)event.getPos(), BackpackBlockEntity.class).map(backpackBlockEntity -> backpackBlockEntity.getStorageWrapper().getUpgradeHandler().getTypeWrappers(InfinityUpgradeItem.TYPE).stream().anyMatch(w -> !w.checkPermission(player))).orElse(false).booleanValue()) {
            event.setCanceled(true);
            player.displayClientMessage((Component)BackpackTranslationHelper.INSTANCE.translStatusMessage("infinity_upgrade_only_admin_break", new Object[0]).withStyle(ChatFormatting.RED), true);
        }
    }
}

