/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper;

import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IEnergyHandlerUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IFluidHandlerWrapperUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTemplate;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTemplates;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackFluidHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackSettingsHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.InventoryModificationHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageFluidHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemResourceHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryIOHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.inventory.StorageWrapperRepository;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderDataHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedcore.util.LootHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import org.jspecify.annotations.Nullable;

public class BackpackWrapper
implements IBackpackWrapper {
    public static final int DEFAULT_MAIN_COLOR = -3382982;
    public static final int DEFAULT_ACCENT_COLOR = -10342886;
    private @Nullable ItemStack backpack;
    private Runnable backpackSaveHandler = () -> {};
    private Runnable inventorySlotChangeHandler = () -> {};
    private @Nullable InventoryHandler handler = null;
    private @Nullable UpgradeHandler upgradeHandler = null;
    private @Nullable InventoryIOHandler inventoryIOHandler = null;
    private @Nullable InventoryModificationHandler inventoryModificationHandler = null;
    private @Nullable BackpackSettingsHandler settingsHandler = null;
    private boolean fluidHandlerInitialized = false;
    private @Nullable IStorageFluidHandler fluidHandler = null;
    private boolean energyStorageInitialized = false;
    private @Nullable EnergyHandler energyStorage = null;
    private @Nullable RenderDataHandler renderDataHandler;
    private IntConsumer onSlotsChange = diff -> {};
    private Runnable onInventoryHandlerRefresh = () -> {};
    private Runnable upgradeCachesInvalidatedHandler = () -> {};
    private Runnable onInventoryForInputOutputHandlerRefresh = () -> {};

    public BackpackWrapper(ItemStack backpackStack) {
        this.setBackpackStack(backpackStack);
    }

    public static IBackpackWrapper fromStack(ItemStack stack) {
        return (IBackpackWrapper)StorageWrapperRepository.getStorageWrapper((ItemStack)stack, IBackpackWrapper.class, BackpackWrapper::new);
    }

    public static Optional<IBackpackWrapper> fromExistingData(ItemStack stack) {
        if (stack.getItem() instanceof BackpackItem) {
            return StorageWrapperRepository.getExistingStorageWrapper((ItemStack)stack, IBackpackWrapper.class);
        }
        return Optional.empty();
    }

    public void setContentsChangeHandler(Runnable contentsChangeHandler) {
        this.backpackSaveHandler = contentsChangeHandler;
        this.refreshInventoryForUpgradeProcessing();
    }

    public void setInventorySlotChangeHandler(Runnable slotChangeHandler) {
        this.inventorySlotChangeHandler = slotChangeHandler;
    }

    public ITrackedContentsItemResourceHandler getInventoryForUpgradeProcessing() {
        if (this.inventoryModificationHandler == null) {
            this.inventoryModificationHandler = new InventoryModificationHandler(this);
        }
        return this.inventoryModificationHandler.getModifiedInventoryHandler();
    }

    public InventoryHandler getInventoryHandler() {
        if (this.handler == null) {
            this.handler = new BackpackInventoryHandler(this.getNumberOfInventorySlots() - this.getNumberOfSlotRows() * this.getColumnsTaken(), this, this.getBackpackContents(), () -> {
                this.markBackpackContentsDirty();
                if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
                    this.inventorySlotChangeHandler.run();
                }
            }, StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this));
            this.handler.addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
        }
        return this.handler;
    }

    private int getNumberOfInventorySlots() {
        Integer inventorySlots = (Integer)this.getBackpackStack().get(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS);
        if (inventorySlots != null) {
            return inventorySlots;
        }
        int itemInventorySlots = ((BackpackItem)this.getBackpackStack().getItem()).getNumberOfSlots();
        this.setNumberOfInventorySlots(itemInventorySlots);
        return itemInventorySlots;
    }

    public int getNumberOfSlotRows() {
        int itemInventorySlots = this.getNumberOfInventorySlots();
        return (int)Math.ceil(itemInventorySlots <= 81 ? (double)itemInventorySlots / 9.0 : (double)itemInventorySlots / 12.0);
    }

    private void setNumberOfInventorySlots(int itemInventorySlots) {
        this.getBackpackStack().set(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)itemInventorySlots);
    }

    private ContainerContents getBackpackContents() {
        return BackpackStorage.get().getOrCreateBackpackContents(this.getOrCreateContentsUuid());
    }

    private void markBackpackContentsDirty() {
        BackpackStorage.get().setDirty();
    }

    public ITrackedContentsItemResourceHandler getInventoryForInputOutput() {
        if (this.inventoryIOHandler == null) {
            this.inventoryIOHandler = new InventoryIOHandler((IStorageWrapper)this);
        }
        return this.inventoryIOHandler.getFilteredItemHandler();
    }

    public Optional<IStorageFluidHandler> getFluidHandler() {
        if (!this.fluidHandlerInitialized) {
            BackpackFluidHandler wrappedHandler = this.getUpgradeHandler().getTypeWrappers(TankUpgradeItem.TYPE).isEmpty() ? null : new BackpackFluidHandler(this);
            List fluidHandlerWrapperUpgrades = this.getUpgradeHandler().getWrappersThatImplement(IFluidHandlerWrapperUpgrade.class);
            for (IFluidHandlerWrapperUpgrade fluidHandlerWrapperUpgrade : fluidHandlerWrapperUpgrades) {
                wrappedHandler = fluidHandlerWrapperUpgrade.wrapHandler(wrappedHandler, this.getBackpackStack());
            }
            this.fluidHandler = wrappedHandler;
            this.fluidHandlerInitialized = true;
        }
        return Optional.ofNullable(this.fluidHandler);
    }

    @Override
    public Optional<ResourceHandler<FluidResource>> getItemFluidHandler() {
        return this.getFluidHandler().map(FluidHandlerItemWrapper::new);
    }

    public Optional<EnergyHandler> getEnergyHandler() {
        if (!this.energyStorageInitialized) {
            EnergyHandler wrappedStorage = this.getUpgradeHandler().getWrappersThatImplement(EnergyHandler.class).stream().findFirst().orElse(null);
            for (IEnergyHandlerUpgradeWrapper energyStorageWrapperUpgrade : this.getUpgradeHandler().getWrappersThatImplement(IEnergyHandlerUpgradeWrapper.class)) {
                wrappedStorage = energyStorageWrapperUpgrade.wrapStorage(wrappedStorage);
            }
            this.energyStorage = wrappedStorage;
        }
        return this.energyStorage == null || this.energyStorage.getCapacityAsInt() == 0 ? Optional.empty() : Optional.of(this.energyStorage);
    }

    @Override
    public void copyDataTo(IStorageWrapper otherStorageWrapper) {
        this.getContentsUuid().ifPresent(originalUuid -> {
            this.getInventoryHandler().copyStacksTo(otherStorageWrapper.getInventoryHandler());
            this.getUpgradeHandler().copyTo(otherStorageWrapper.getUpgradeHandler());
            this.getSettingsHandler().copyTo(otherStorageWrapper.getSettingsHandler());
        });
    }

    @Override
    public IBackpackWrapper setBackpackStack(ItemStack backpack) {
        this.backpack = backpack;
        if (this.renderDataHandler == null) {
            Supplier<Runnable> getSaveHandler = () -> this.backpackSaveHandler;
            this.renderDataHandler = new RenderDataHandler(Optional.ofNullable((RenderData)backpack.get(ModCoreDataComponents.RENDER_DATA)).map(RenderData::copy).orElseGet(RenderData::new), renderData -> {
                backpack.set(ModCoreDataComponents.RENDER_DATA, (Object)renderData.copy());
                ((Runnable)getSaveHandler.get()).run();
            });
        }
        return this;
    }

    @Override
    public BackpackSettingsHandler getSettingsHandler() {
        if (this.settingsHandler == null) {
            this.settingsHandler = this.getContentsUuid().isPresent() ? new BackpackSettingsHandler(this, this.getBackpackContents().settings(), this::markBackpackContentsDirty) : IBackpackWrapper.Noop.INSTANCE.getSettingsHandler();
        }
        return this.settingsHandler;
    }

    public UpgradeHandler getUpgradeHandler() {
        if (this.upgradeHandler == null) {
            this.upgradeHandler = this.getContentsUuid().isPresent() ? new UpgradeHandler(this, this.getNumberOfUpgradeSlots(), this, this.getBackpackContents(), this::markBackpackContentsDirty, () -> {
                if (this.handler != null) {
                    this.handler.clearListeners();
                    this.handler.setBaseSlotLimit(StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this));
                }
                this.getInventoryHandler().clearListeners();
                this.handler.addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
                this.inventoryIOHandler = null;
                this.inventoryModificationHandler = null;
                this.fluidHandlerInitialized = false;
                this.fluidHandler = null;
                this.energyStorageInitialized = false;
                this.energyStorage = null;
                this.upgradeCachesInvalidatedHandler.run();
            }){

                public boolean isValid(int index, ItemResource resource) {
                    return super.isValid(index, resource) && (resource.isEmpty() || resource.is(ModItems.BACKPACK_UPGRADE_TAG));
                }
            } : IBackpackWrapper.Noop.INSTANCE.getUpgradeHandler();
        }
        return this.upgradeHandler;
    }

    public void setUpgradeCachesInvalidatedHandler(Runnable handler) {
        this.upgradeCachesInvalidatedHandler = handler;
    }

    private int getNumberOfUpgradeSlots() {
        Integer upgradeSlots = (Integer)this.getBackpackStack().get(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS);
        if (upgradeSlots != null) {
            return upgradeSlots;
        }
        int itemUpgradeSlots = ((BackpackItem)this.getBackpackStack().getItem()).getNumberOfUpgradeSlots();
        this.setNumberOfUpgradeSlots(itemUpgradeSlots);
        return itemUpgradeSlots;
    }

    public Optional<UUID> getContentsUuid() {
        return Optional.ofNullable((UUID)this.getBackpackStack().get(ModCoreDataComponents.STORAGE_UUID));
    }

    private UUID getOrCreateContentsUuid() {
        Optional<UUID> contentsUuid = this.getContentsUuid();
        if (contentsUuid.isPresent()) {
            return contentsUuid.get();
        }
        this.clearDummyHandlers();
        UUID newUuid = UUID.randomUUID();
        this.setContentsUuid(newUuid);
        return newUuid;
    }

    private void clearDummyHandlers() {
        if (this.upgradeHandler == IBackpackWrapper.Noop.INSTANCE.getUpgradeHandler()) {
            this.upgradeHandler = null;
        }
        if (this.settingsHandler == IBackpackWrapper.Noop.INSTANCE.getSettingsHandler()) {
            this.settingsHandler = null;
        }
    }

    public int getMainColor() {
        return (Integer)this.getBackpackStack().getOrDefault(ModCoreDataComponents.MAIN_COLOR, (Object)-3382982);
    }

    public int getAccentColor() {
        return (Integer)this.getBackpackStack().getOrDefault(ModCoreDataComponents.ACCENT_COLOR, (Object)-10342886);
    }

    public Optional<Integer> getOpenTabId() {
        return Optional.ofNullable((Integer)this.getBackpackStack().get(ModCoreDataComponents.OPEN_TAB_ID));
    }

    public void setOpenTabId(int openTabId) {
        this.getBackpackStack().set(ModCoreDataComponents.OPEN_TAB_ID, (Object)openTabId);
        this.backpackSaveHandler.run();
    }

    public void removeOpenTabId() {
        this.getBackpackStack().remove(ModCoreDataComponents.OPEN_TAB_ID);
        this.backpackSaveHandler.run();
    }

    public void setColors(int mainColor, int accentColor) {
        ItemStack backpackStack = this.getBackpackStack();
        BackpackItem.setColors(backpackStack, mainColor, accentColor);
        this.backpackSaveHandler.run();
    }

    public void setSortBy(SortBy sortBy) {
        this.getBackpackStack().set(ModCoreDataComponents.SORT_BY, (Object)sortBy);
        this.backpackSaveHandler.run();
    }

    public SortBy getSortBy() {
        return (SortBy)this.getBackpackStack().getOrDefault(ModCoreDataComponents.SORT_BY, (Object)SortBy.NAME);
    }

    public void sort() {
        HashSet slotIndexesExcludedFromSort = new HashSet();
        slotIndexesExcludedFromSort.addAll(((NoSortSettingsCategory)this.getSettingsHandler().getTypeCategory(NoSortSettingsCategory.class)).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(((MemorySettingsCategory)this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).getSlotIndexes());
        InventorySorter.sortHandler((InventoryHandler)this.getInventoryHandler(), this.getComparator(), slotIndexesExcludedFromSort);
    }

    private Comparator<Map.Entry<ItemStackKey, Integer>> getComparator() {
        return switch (this.getSortBy()) {
            default -> throw new MatchException(null, null);
            case SortBy.COUNT -> InventorySorter.BY_COUNT;
            case SortBy.TAGS -> InventorySorter.BY_TAGS;
            case SortBy.NAME -> InventorySorter.BY_NAME;
            case SortBy.MOD -> InventorySorter.BY_MOD;
        };
    }

    @Override
    public ItemStack getBackpack() {
        return this.getBackpackStack();
    }

    @Override
    public ItemStack cloneBackpack() {
        ItemStack clonedBackpack = this.cloneBackpack(this);
        this.cloneSubbackpacks(BackpackWrapper.fromStack(clonedBackpack));
        return clonedBackpack;
    }

    private void cloneSubbackpacks(IStorageWrapper wrapperCloned) {
        InventoryHandler inventoryHandler = wrapperCloned.getInventoryHandler();
        InventoryHelper.iterate((ResourceHandler)inventoryHandler, (slot, stack) -> {
            if (!(stack.getItem() instanceof BackpackItem)) {
                return;
            }
            inventoryHandler.setStackInSlot(slot.intValue(), this.cloneBackpack(BackpackWrapper.fromStack(stack)));
        });
    }

    private ItemStack cloneBackpack(IBackpackWrapper originalWrapper) {
        ItemStack backpackCopy = originalWrapper.getBackpack().copy();
        backpackCopy.remove(ModCoreDataComponents.STORAGE_UUID);
        IBackpackWrapper wrapperCopy = BackpackWrapper.fromStack(backpackCopy);
        originalWrapper.copyDataTo(wrapperCopy);
        return wrapperCopy.getBackpack();
    }

    public void refreshInventoryForInputOutput() {
        this.inventoryIOHandler = null;
        this.upgradeCachesInvalidatedHandler.run();
        this.onInventoryForInputOutputHandlerRefresh.run();
    }

    public void setPersistent(boolean persistent) {
        this.getInventoryHandler().setPersistent(persistent);
        this.getUpgradeHandler().setPersistent(persistent);
    }

    @Override
    public void setSlotNumbers(int numberOfInventorySlots, int numberOfUpgradeSlots) {
        this.setNumberOfInventorySlots(numberOfInventorySlots);
        this.setNumberOfUpgradeSlots(numberOfUpgradeSlots);
    }

    @Override
    public void setLoot(Identifier lootTableName, float lootFactor) {
        this.getBackpackStack().set(ModDataComponents.LOOT_TABLE, (Object)lootTableName);
        this.getBackpackStack().set(ModDataComponents.LOOT_FACTOR, (Object)Float.valueOf(lootFactor));
        this.backpackSaveHandler.run();
    }

    @Override
    public void setTemplate(Identifier templateName) {
        this.getBackpackStack().set(ModDataComponents.TEMPLATE_NAME, (Object)templateName);
    }

    public void fillWithLoot(Player player) {
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        BlockPos pos = player.blockPosition();
        this.fillFromTemplate();
        this.fillWithLoot(level, pos);
        this.fillWithExtraItems(stack -> InventoryHelper.insertOrDropItem((Player)player, (ItemStack)stack, (ResourceHandler)this.getInventoryHandler()));
    }

    private void fillWithExtraItems(Consumer<ItemStack> insertOrDropItem) {
        ItemStack backpack = this.getBackpackStack();
        if (!backpack.has(DataComponents.CONTAINER)) {
            return;
        }
        ItemContainerContents containerItems = (ItemContainerContents)backpack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        for (int slot = 0; slot < containerItems.getSlots(); ++slot) {
            ItemStack stack = containerItems.getStackInSlot(slot);
            if (stack.isEmpty()) continue;
            insertOrDropItem.accept(stack);
        }
        backpack.remove(DataComponents.CONTAINER);
    }

    @Override
    public void fillWithLootAndExtraItems(Level level, BlockPos pos) {
        this.fillWithLoot(level, pos);
        this.fillWithExtraItems(stack -> {
            int inserted = InventoryHelper.insert((ResourceHandler)this.getInventoryHandler(), (ItemResource)ItemResource.of((ItemStack)stack), (int)stack.getCount());
            if (inserted < stack.getCount()) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack.copyWithCount(stack.getCount() - inserted));
            }
        });
    }

    public void fillWithLoot(Level level, BlockPos pos) {
        Identifier lootTable = (Identifier)this.getBackpackStack().get(ModDataComponents.LOOT_TABLE);
        if (lootTable == null) {
            return;
        }
        this.fillWithLootFromTable(level, pos, lootTable);
    }

    @Override
    public void fillFromTemplate() {
        ItemStack backpack = this.getBackpackStack();
        Identifier templateName = (Identifier)backpack.get(ModDataComponents.TEMPLATE_NAME);
        if (templateName == null) {
            return;
        }
        Optional<BackpackTemplate> templateData = BackpackTemplates.getBackpackTemplate(templateName);
        if (templateData.isEmpty()) {
            return;
        }
        BackpackStorage.get().setBackpackContents(this.getOrCreateContentsUuid(), templateData.get().contents());
        backpack.remove(ModDataComponents.TEMPLATE_NAME);
    }

    @Override
    public void setContentsUuid(UUID storageUuid) {
        this.getBackpackStack().set(ModCoreDataComponents.STORAGE_UUID, (Object)storageUuid);
    }

    @Override
    public void removeContentsUuid() {
        this.getContentsUuid().ifPresent(BackpackStorage.get()::removeBackpackContents);
        this.removeContentsUUIDTag();
    }

    @Override
    public void removeContentsUUIDTag() {
        this.getBackpackStack().remove(ModCoreDataComponents.STORAGE_UUID);
    }

    private ItemStack getBackpackStack() {
        if (this.backpack == null) {
            throw new IllegalStateException("Backpack stack not set");
        }
        return this.backpack;
    }

    public RenderDataHandler getRenderDataHandler() {
        return this.renderDataHandler;
    }

    public void setColumnsTaken(int columnsTaken, boolean hasChanged) {
        int originalColumnsTaken = this.getColumnsTaken();
        this.getBackpackStack().set(ModDataComponents.COLUMNS_TAKEN, (Object)columnsTaken);
        if (hasChanged) {
            int diff = (columnsTaken - originalColumnsTaken) * this.getNumberOfSlotRows();
            this.onSlotsChange.accept(diff);
        }
        this.backpackSaveHandler.run();
    }

    @Override
    public void registerOnSlotsChangeListener(IntConsumer onSlotsChange) {
        this.onSlotsChange = onSlotsChange;
    }

    @Override
    public void unregisterOnSlotsChangeListener() {
        this.onSlotsChange = diff -> {};
    }

    public int getColumnsTaken() {
        return (Integer)this.getBackpackStack().getOrDefault(ModDataComponents.COLUMNS_TAKEN, (Object)0);
    }

    private void fillWithLootFromTable(Level level, BlockPos pos, Identifier lootTable) {
        MinecraftServer server = level.getServer();
        if (server == null || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        float lootFactor = ((Float)this.getBackpackStack().getOrDefault(ModDataComponents.LOOT_FACTOR, (Object)Float.valueOf(0.0f))).floatValue();
        this.getBackpackStack().remove(ModDataComponents.LOOT_TABLE);
        this.getBackpackStack().remove(ModDataComponents.LOOT_FACTOR);
        List loot = LootHelper.getLoot((Identifier)lootTable, (MinecraftServer)server, (ServerLevel)serverLevel, (BlockPos)pos);
        loot.removeIf(stack -> stack.getItem() instanceof BackpackItem);
        loot = RandHelper.getNRandomElements((List)loot, (int)((int)((float)loot.size() * lootFactor)));
        LootHelper.fillWithLoot((RandomSource)serverLevel.random, (List)loot, (InventoryHandler)this.getInventoryHandler());
    }

    private void setNumberOfUpgradeSlots(int numberOfUpgradeSlots) {
        this.getBackpackStack().set(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)numberOfUpgradeSlots);
    }

    public void refreshInventoryForUpgradeProcessing() {
        this.inventoryModificationHandler = null;
        this.fluidHandler = null;
        this.fluidHandlerInitialized = false;
        this.energyStorage = null;
        this.energyStorageInitialized = false;
        this.refreshInventoryForInputOutput();
    }

    public void onContentsUpdated() {
        this.handler = null;
        this.upgradeHandler = null;
        this.refreshInventoryForUpgradeProcessing();
        this.onInventoryHandlerRefresh.run();
    }

    @Override
    public void registerOnInventoryHandlerRefreshListener(Runnable onInventoryHandlerRefresh) {
        this.onInventoryHandlerRefresh = onInventoryHandlerRefresh;
    }

    public void registerOnInventoryInputOutputHandlerRefreshListener(Runnable onInventoryForInputOutputHandlerRefresh) {
        this.onInventoryForInputOutputHandlerRefresh = onInventoryForInputOutputHandlerRefresh;
    }

    @Override
    public void unregisterOnInventoryHandlerRefreshListener() {
        this.onInventoryHandlerRefresh = () -> {};
    }

    public ItemStack getWrappedStorageStack() {
        return this.getBackpack();
    }

    public String getStorageType() {
        return "backpack";
    }

    public Component getDisplayName() {
        return this.getBackpack().getHoverName();
    }

    private static class FluidHandlerItemWrapper
    implements ResourceHandler<FluidResource> {
        private final ResourceHandler<FluidResource> delegate;

        public FluidHandlerItemWrapper(ResourceHandler<FluidResource> delegate) {
            this.delegate = delegate;
        }

        public int size() {
            return this.delegate.size();
        }

        public FluidResource getResource(int index) {
            return (FluidResource)this.delegate.getResource(index);
        }

        public long getAmountAsLong(int index) {
            return this.delegate.getAmountAsLong(index);
        }

        public long getCapacityAsLong(int index, FluidResource resource) {
            return this.delegate.getCapacityAsLong(index, (Resource)resource);
        }

        public boolean isValid(int index, FluidResource resource) {
            return this.delegate.isValid(index, (Resource)resource);
        }

        public int insert(int index, FluidResource resource, int amount, TransactionContext tx) {
            return this.delegate.insert(index, (Resource)resource, amount, tx);
        }

        public int extract(int index, FluidResource resource, int amount, TransactionContext tx) {
            return this.delegate.extract(index, (Resource)resource, amount, tx);
        }
    }
}

