/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import com.google.common.collect.Maps;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.Identifier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.p3pp3rf1y.sophisticatedbackpacks.SophisticatedBackpacks;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTemplate;
import org.apache.commons.io.IOUtils;

public class DatapackBackpackTemplateManager {
    private static final Map<Identifier, BackpackTemplate> TEMPLATES = Maps.newTreeMap();

    private DatapackBackpackTemplateManager() {
    }

    private static void putBackpackTemplate(Identifier templateName, BackpackTemplate tag) {
        TEMPLATES.put(templateName, tag);
    }

    public static Map<Identifier, BackpackTemplate> getBackpackTemplates() {
        return TEMPLATES;
    }

    public static Optional<BackpackTemplate> getBackpackTemplate(Identifier templateName) {
        return Optional.ofNullable(TEMPLATES.get(templateName));
    }

    public static class Loader
    extends SimplePreparableReloadListener<Map<Identifier, BackpackTemplate>> {
        public static final Identifier KEY = SophisticatedBackpacks.getIdentifier("template_loader");
        public static final Loader INSTANCE = new Loader();
        private static final String DIRECTORY = "sophisticatedbackpacks_templates";
        private static final String SUFFIX = ".snbt";
        private static final int PATH_SUFFIX_LENGTH = ".snbt".length();

        private Loader() {
        }

        protected Map<Identifier, BackpackTemplate> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
            HashMap map = Maps.newHashMap();
            int i = DIRECTORY.length() + 1;
            resourceManager.listResources(DIRECTORY, fileName -> fileName.getPath().endsWith(SUFFIX)).forEach((identifier, resource) -> {
                String s = identifier.getPath();
                Identifier identifierWithoutSuffix = Identifier.fromNamespaceAndPath((String)identifier.getNamespace(), (String)s.substring(i, s.length() - PATH_SUFFIX_LENGTH));
                try (InputStream inputstream = resource.open();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(inputstream, StandardCharsets.UTF_8));){
                    String fileContents = IOUtils.toString((Reader)reader);
                    BackpackTemplate template = (BackpackTemplate)((Pair)BackpackTemplate.CODEC.decode((DynamicOps)this.getRegistryLookup().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)TagParser.parseCompoundFully((String)fileContents)).getOrThrow()).getFirst();
                    if (map.put(identifierWithoutSuffix, template) != null) {
                        throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(identifierWithoutSuffix));
                    }
                }
                catch (CommandSyntaxException | IOException | IllegalArgumentException ex) {
                    SophisticatedBackpacks.LOGGER.error("Couldn't parse data file {} from {}", (Object)identifierWithoutSuffix, identifier, (Object)ex);
                }
            });
            return map;
        }

        protected void apply(Map<Identifier, BackpackTemplate> templates, ResourceManager resourceManager, ProfilerFiller profiler) {
            templates.forEach(DatapackBackpackTemplateManager::putBackpackTemplate);
        }
    }
}

