/*
 * Decompiled with CFR 0.152.
 */
package one.pkg.mod.krypton_fnp.shared.network.compression;

import com.google.common.base.Preconditions;
import com.velocitypowered.natives.Native;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.util.MoreByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import one.pkg.mod.krypton_fnp.shared.ModConfig;
import one.pkg.mod.krypton_fnp.shared.network.util.SystemInfo;

public class MinecraftCompressDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final int VANILLA_MAXIMUM_UNCOMPRESSED_SIZE = 0x800000;
    private static final int HARD_MAXIMUM_UNCOMPRESSED_SIZE = 0x8000000;
    private static final int UNCOMPRESSED_CAP = ModConfig.Compression.isPermitOversizedPackets() ? 0x8000000 : 0x800000;
    private final VelocityCompressor compressor;
    private final VelocityCompressor jCompressor;
    private final boolean validate;
    private int threshold;

    public MinecraftCompressDecoder(int threshold, boolean validate, VelocityCompressor compressor, VelocityCompressor jCompressor) {
        this.threshold = threshold;
        this.compressor = compressor;
        this.jCompressor = jCompressor;
        this.validate = validate;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        boolean v;
        FriendlyByteBuf bb = new FriendlyByteBuf(in);
        int claimedUncompressedSize = bb.readVarInt();
        if (claimedUncompressedSize == 0) {
            int actualUncompressedSize = in.readableBytes();
            Preconditions.checkState((actualUncompressedSize < this.threshold ? 1 : 0) != 0, (String)"Actual uncompressed size %s is greater than threshold %s", (int)actualUncompressedSize, (int)this.threshold);
            out.add(in.retain());
            return;
        }
        if (this.validate) {
            Preconditions.checkState((claimedUncompressedSize >= this.threshold ? 1 : 0) != 0, (String)"Uncompressed size %s is less than threshold %s", (int)claimedUncompressedSize, (int)this.threshold);
            Preconditions.checkState((claimedUncompressedSize <= UNCOMPRESSED_CAP ? 1 : 0) != 0, (String)"Uncompressed size %s exceeds hard threshold of %s", (int)claimedUncompressedSize, (int)UNCOMPRESSED_CAP);
        }
        this.decompress((v = this.shouldUseJavaFallback(claimedUncompressedSize, in)) ? this.jCompressor : this.compressor, ctx, in, out, claimedUncompressedSize);
    }

    private boolean detectRepetitiveData(ByteBuf compressed) {
        int readableBytes = compressed.readableBytes();
        if (readableBytes < 32) {
            return false;
        }
        int readerIndex = compressed.readerIndex();
        int sampleSize = Math.min(64, readableBytes);
        double threshold = ModConfig.Compression.BlendingMode.getRepetitiveThreshold();
        int minRequiredFreq = (int)Math.ceil((double)sampleSize * threshold);
        if (sampleSize >= 8) {
            short firstByte = compressed.getUnsignedByte(readerIndex);
            int consecutiveCount = 1;
            for (int i = 1; i < Math.min(8, sampleSize) && compressed.getUnsignedByte(readerIndex + i) == firstByte; ++i) {
                ++consecutiveCount;
            }
            if (consecutiveCount >= minRequiredFreq || consecutiveCount >= sampleSize / 2) {
                return true;
            }
        }
        int[] byteFreq = new int[256];
        for (int i = 0; i < sampleSize; ++i) {
            short b;
            short s = b = compressed.getUnsignedByte(readerIndex + i);
            byteFreq[s] = byteFreq[s] + 1;
            if (byteFreq[s] < minRequiredFreq) continue;
            return true;
        }
        return false;
    }

    private void decompress(VelocityCompressor compressor, ChannelHandlerContext ctx, ByteBuf in, List<Object> out, int claimedUncompressedSize) throws Exception {
        ByteBuf compatibleIn = MoreByteBufUtils.ensureCompatible((ByteBufAllocator)ctx.alloc(), (Native)compressor, (ByteBuf)in);
        ByteBuf uncompressed = MoreByteBufUtils.preferredBuffer((ByteBufAllocator)ctx.alloc(), (Native)compressor, (int)claimedUncompressedSize);
        try {
            compressor.inflate(compatibleIn, uncompressed, claimedUncompressedSize);
            out.add(uncompressed);
        }
        catch (Exception e) {
            uncompressed.release();
            throw e;
        }
        finally {
            compatibleIn.release();
        }
    }

    private boolean shouldUseJavaFallback(int claimedUncompressedSize, ByteBuf compressed) {
        if (this.jCompressor == null || !SystemInfo.IS_LINUX || claimedUncompressedSize < ModConfig.Compression.BlendingMode.getLinuxFallbackMinSize()) {
            return false;
        }
        return this.detectRepetitiveData(compressed);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.compressor.close();
        if (this.jCompressor != null) {
            this.jCompressor.close();
        }
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

