/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.type;

import net.minecraft.core.Vec3i;
import org.joml.Vector3d;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.type.ColorType;

public class Color {
    public static final Color NONE = new Color(0);
    public static final Color WHITE = new Color(-1);
    public static final Color RED = new Color(-65536);
    public static final Color GREEN = new Color(-16711936);
    public static final Color BLUE = new Color(-16776961);
    public static final Color LIGHT_BLUE = new Color(-16740609);
    public static final Color ORANGE = new Color(-23296);
    public static final Color YELLOW = new Color(-256);
    public static final Color CYAN = new Color(0xFF0001);
    public static final Color MAGENTA = new Color(-65281);
    public static final Color BLACK = new Color(-16777216);
    protected short red;
    protected short green;
    protected short blue;
    protected short alpha;

    public Color() {
        this(255, 255, 255, 255);
    }

    public Color(Color color) {
        this.set(color);
    }

    public Color(int color) {
        this.alpha = (short)(color >> 24 & 0xFF);
        this.red = (short)(color >> 16 & 0xFF);
        this.green = (short)(color >> 8 & 0xFF);
        this.blue = (short)(color & 0xFF);
    }

    public Color(float r, float g, float b) {
        this((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), 255);
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    public Color(short r, short g, short b) {
        this(r, g, b, 255);
    }

    public Color(float r, float g, float b, float a) {
        this((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public Color(int r, int g, int b, int a) {
        this.red = (short)r;
        this.green = (short)g;
        this.blue = (short)b;
        this.alpha = (short)a;
    }

    public Color(short r, short g, short b, short a) {
        this.red = r;
        this.green = g;
        this.blue = b;
        this.alpha = a;
    }

    public Color(Vec3i vec) {
        this.red = (short)vec.getX();
        this.green = (short)vec.getY();
        this.blue = (short)vec.getZ();
        this.alpha = (short)255;
    }

    public Color(Vector3d vec) {
        this.red = (short)(vec.x * 255.0);
        this.green = (short)(vec.y * 255.0);
        this.blue = (short)(vec.z * 255.0);
        this.alpha = (short)255;
    }

    public void set(Color color) {
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
        this.alpha = color.getAlpha();
    }

    public void set(int color) {
        this.red = (short)ColorUtils.red(color);
        this.green = (short)ColorUtils.green(color);
        this.blue = (short)ColorUtils.blue(color);
        this.alpha = (short)ColorUtils.alpha(color);
    }

    public void set(ColorType type, int value) {
        this.set(type, (short)value);
    }

    public void set(ColorType type, short value) {
        switch (type) {
            case ALPHA: {
                this.alpha = value;
                break;
            }
            case RED: {
                this.red = value;
                break;
            }
            case GREEN: {
                this.green = value;
                break;
            }
            case BLUE: {
                this.blue = value;
            }
        }
    }

    public void setAlpha(int a) {
        this.alpha = (short)a;
    }

    public void setAlpha(short a) {
        this.alpha = a;
    }

    public void setRed(int r) {
        this.red = (short)r;
    }

    public void setRed(short r) {
        this.red = r;
    }

    public void setGreen(int g) {
        this.green = (short)g;
    }

    public void setGreen(short g) {
        this.green = g;
    }

    public void setBlue(int b) {
        this.blue = (short)b;
    }

    public void setBlue(short b) {
        this.blue = b;
    }

    public short get(ColorType type) {
        return switch (type) {
            case ColorType.ALPHA -> this.alpha;
            case ColorType.RED -> this.red;
            case ColorType.GREEN -> this.green;
            case ColorType.BLUE -> this.blue;
            default -> 0;
        };
    }

    public short getAlpha() {
        return this.alpha;
    }

    public short getRed() {
        return this.red;
    }

    public short getGreen() {
        return this.green;
    }

    public short getBlue() {
        return this.blue;
    }

    public float getDecimal(ColorType type) {
        return switch (type) {
            case ColorType.ALPHA -> (float)this.alpha / 255.0f;
            case ColorType.RED -> (float)this.red / 255.0f;
            case ColorType.GREEN -> (float)this.green / 255.0f;
            case ColorType.BLUE -> (float)this.blue / 255.0f;
            default -> 0.0f;
        };
    }

    public float getAlphaDecimal() {
        return (float)this.alpha / 255.0f;
    }

    public float getRedDecimal() {
        return (float)this.red / 255.0f;
    }

    public float getGreenDecimal() {
        return (float)this.green / 255.0f;
    }

    public float getBlueDecimal() {
        return (float)this.blue / 255.0f;
    }

    public int toInt() {
        return (this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
    }

    public boolean isDefault() {
        return this.red == 255 && this.green == 255 && this.blue == 255 && this.alpha == 255;
    }

    public boolean isWhite() {
        return this.red == 255 && this.green == 255 && this.blue == 255;
    }

    public boolean isTransparent() {
        return this.alpha < 255;
    }

    public boolean isInvisible() {
        return this.alpha == 0;
    }

    public void blend(Color color) {
        this.blend(color, 0.5f);
    }

    public void blend(Color color, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        this.alpha = (short)((float)this.alpha * iRatio + (float)color.alpha * ratio);
        this.red = (short)((float)this.red * iRatio + (float)color.red * ratio);
        this.green = (short)((float)this.green * iRatio + (float)color.green * ratio);
        this.blue = (short)((float)this.blue * iRatio + (float)color.blue * ratio);
    }

    public Vec3d toVec() {
        return new Vec3d((double)this.red / 255.0, (double)this.green / 255.0, (double)this.blue / 255.0);
    }

    public static boolean isWhite(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        return r == 255 && g == 255 && b == 255;
    }

    public static boolean isTransparent(int color) {
        int a = color >> 24 & 0xFF;
        return a < 255;
    }

    public static boolean isInvisible(int color) {
        int a = color >> 24 & 0xFF;
        return a == 0;
    }

    public static Color blend(Color color1, Color color2) {
        return Color.blend(color1, color2, 0.5f);
    }

    public static Color blend(Color color1, Color color2, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        short a = (short)((float)color1.alpha * iRatio + (float)color2.alpha * ratio);
        short r = (short)((float)color1.red * iRatio + (float)color2.red * ratio);
        short g = (short)((float)color1.green * iRatio + (float)color2.green * ratio);
        short b = (short)((float)color1.blue * iRatio + (float)color2.blue * ratio);
        return new Color(r, g, b, a);
    }

    public static int blend(int i1, int i2) {
        return Color.blend(i1, i2, 0.5f);
    }

    public static int blend(int i1, int i2, float ratio) {
        if (ratio > 1.0f) {
            ratio = 1.0f;
        } else if (ratio < 0.0f) {
            ratio = 0.0f;
        }
        float iRatio = 1.0f - ratio;
        int a1 = i1 >> 24 & 0xFF;
        int r1 = (i1 & 0xFF0000) >> 16;
        int g1 = (i1 & 0xFF00) >> 8;
        int b1 = i1 & 0xFF;
        int a2 = i2 >> 24 & 0xFF;
        int r2 = (i2 & 0xFF0000) >> 16;
        int g2 = (i2 & 0xFF00) >> 8;
        int b2 = i2 & 0xFF;
        int a = (int)((float)a1 * iRatio + (float)a2 * ratio);
        int r = (int)((float)r1 * iRatio + (float)r2 * ratio);
        int g = (int)((float)g1 * iRatio + (float)g2 * ratio);
        int b = (int)((float)b1 * iRatio + (float)b2 * ratio);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public String hex() {
        return ColorUtils.toHex(this.toInt());
    }
}

