/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiCheckList;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlockTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientFuel;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemTag;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;

@Environment(value=EnvType.CLIENT)
public abstract class GuiCreativeIngredientHandler {
    public static final NamedHandlerRegistry<GuiCreativeIngredientHandler> REGISTRY = new NamedHandlerRegistry<Object>(null);

    public static GuiCreativeIngredientHandler find(CreativeIngredient info) {
        if (info != null) {
            for (GuiCreativeIngredientHandler handler : REGISTRY.values()) {
                if (!handler.canHandle(info)) continue;
                return handler;
            }
        }
        return REGISTRY.getDefault();
    }

    public abstract boolean canHandle(CreativeIngredient var1);

    public abstract void createControls(GuiParent var1, CreativeIngredient var2);

    public abstract CreativeIngredient parseControls(GuiParent var1);

    public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
    }

    static {
        REGISTRY.registerDefault("Default", new GuiCreativeIngredientHandler(){

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                List<Identifier> list;
                GuiStackSelector selector = (GuiStackSelector)new GuiStackSelector(gui, "inv", new GuiStackSelector.CreativeCollector(new GuiStackSelector.SearchSelector())).setExpandableX();
                gui.add((GuiControl)selector);
                if (info instanceof CreativeIngredientItemStack) {
                    CreativeIngredientItemStack s = (CreativeIngredientItemStack)info;
                    list = s.getIncluded();
                } else {
                    list = new ArrayList<Identifier>();
                }
                gui.add((GuiControl)new GuiDataCheckList((IGuiParent)gui, "list", false, null, list).setExpandable());
                if (info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack) {
                    selector.setSelectedForce(info.getExample().copy());
                }
                this.onChanged(gui, new GuiControlChangedEvent<GuiStackSelector>(selector));
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientBlock || info instanceof CreativeIngredientItem || info instanceof CreativeIngredientItemStack;
            }

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                ItemStack stack = gui.get("inv", GuiStackSelector.class).getSelected();
                if (stack != null) {
                    GuiDataCheckList list = (GuiDataCheckList)gui.get("list");
                    List<Identifier> included = list.getConfiguredIncluded();
                    if (included.isEmpty()) {
                        if (!(Block.byItem((Item)stack.getItem()) instanceof AirBlock)) {
                            return new CreativeIngredientBlock(Block.byItem((Item)stack.getItem()));
                        }
                        return new CreativeIngredientItem(stack.getItem());
                    }
                    return new CreativeIngredientItemStack(stack, included);
                }
                return null;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                GuiControl guiControl;
                if (event.control.is("inv") && (guiControl = event.control) instanceof GuiStackSelector) {
                    GuiStackSelector selector = (GuiStackSelector)guiControl;
                    GuiDataCheckList list = (GuiDataCheckList)gui.get("list");
                    ItemStack stack = selector.getSelected();
                    TextMapBuilder<DataComponentType> map = new TextMapBuilder<DataComponentType>();
                    Object2BooleanArrayMap selected = new Object2BooleanArrayMap();
                    CompoundTag nbt = (CompoundTag)ItemStack.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)stack).getOrThrow();
                    if (!(nbt = nbt.getCompoundOrEmpty("components")).isEmpty()) {
                        for (String component : nbt.keySet()) {
                            Identifier location = Identifier.parse((String)component);
                            DataComponentType type = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.getValue(location);
                            map.addComponent(type, (Component)Component.literal((String)component).append(": ").append((Component)Component.literal((String)((String)nbt.get(component).asString().get())).withStyle(ChatFormatting.GRAY)));
                            if (!list.includes(type)) continue;
                            selected.put((Object)type, true);
                        }
                    }
                    list.set(map, selected);
                    gui.reflow();
                }
            }
        });
        REGISTRY.register("Blocktag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                GuiComboBox box = (GuiComboBox)gui.get("tag");
                TagKey tag = (TagKey)box.selected();
                if (tag != null) {
                    return new CreativeIngredientBlockTag((TagKey<Block>)tag);
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.setFlow(GuiFlow.STACK_Y);
                gui.setAlign(Align.STRETCH);
                GuiComboBox<TagKey> box = new GuiComboBox<TagKey>(gui, "tag", new TextMapBuilder<TagKey>().addComponents(BuiltInRegistries.BLOCK.getTags().map(x -> (TagKey)x.unwrapKey().get()).toList(), x -> {
                    TextBuilder builder = new TextBuilder();
                    Iterator itr = BuiltInRegistries.BLOCK.getTagOrEmpty(x).iterator();
                    if (itr.hasNext()) {
                        builder.stack(new ItemStack((ItemLike)((Holder)itr.next()).value()));
                    }
                    return builder.text(x.location().toString()).build();
                }));
                gui.add((GuiControl)box);
                gui.add((GuiControl)new GuiTextfield(gui, "search"));
                if (info instanceof CreativeIngredientBlockTag) {
                    box.select(((CreativeIngredientBlockTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientBlockTag;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBox box = (GuiComboBox)gui.get("tag");
                    box.set(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(BuiltInRegistries.BLOCK.getTags().map(x -> (TagKey)x.unwrapKey().get()).toList(), x -> {
                        TextBuilder builder = new TextBuilder();
                        Iterator itr = BuiltInRegistries.BLOCK.getTagOrEmpty(x).iterator();
                        if (itr.hasNext()) {
                            builder.stack(new ItemStack((ItemLike)((Holder)itr.next()).value()));
                        }
                        return builder.text(x.location().toString()).build();
                    }));
                }
            }
        });
        REGISTRY.register("Itemtag", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                GuiComboBox box = (GuiComboBox)gui.get("tag");
                TagKey tag = (TagKey)box.selected();
                if (tag != null) {
                    return new CreativeIngredientItemTag((TagKey<Item>)tag);
                }
                return null;
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.setFlow(GuiFlow.STACK_Y);
                gui.setAlign(Align.STRETCH);
                GuiComboBox<TagKey> box = new GuiComboBox<TagKey>(gui, "tag", new TextMapBuilder<TagKey>().addComponents(BuiltInRegistries.ITEM.getTags().map(x -> (TagKey)x.unwrapKey().get()).toList(), x -> {
                    TextBuilder builder = new TextBuilder();
                    Iterator itr = BuiltInRegistries.ITEM.getTagOrEmpty(x).iterator();
                    if (itr.hasNext()) {
                        builder.stack(new ItemStack((ItemLike)((Holder)itr.next()).value()));
                    }
                    return builder.text(x.location().toString()).build();
                }));
                gui.add((GuiControl)box);
                gui.add((GuiControl)new GuiTextfield(gui, "search"));
                if (info instanceof CreativeIngredientItemTag) {
                    box.select(((CreativeIngredientItemTag)info).tag);
                }
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientItemTag;
            }

            @Override
            public void onChanged(GuiParent gui, GuiControlChangedEvent event) {
                if (event.control.is("search")) {
                    GuiComboBox box = (GuiComboBox)gui.get("tag");
                    box.set(new TextMapBuilder().setFilter(x -> x.toLowerCase().contains(((GuiTextfield)event.control).getText())).addComponents(BuiltInRegistries.ITEM.getTags().map(x -> (TagKey)x.unwrapKey().get()).toList(), x -> {
                        TextBuilder builder = new TextBuilder();
                        Iterator itr = BuiltInRegistries.ITEM.getTagOrEmpty(x).iterator();
                        if (itr.hasNext()) {
                            builder.stack(new ItemStack((ItemLike)((Holder)itr.next()).value()));
                        }
                        return builder.text(x.location().toString()).build();
                    }));
                }
            }
        });
        REGISTRY.register("Fuel", new GuiCreativeIngredientHandler(){

            @Override
            public CreativeIngredient parseControls(GuiParent gui) {
                return new CreativeIngredientFuel();
            }

            @Override
            public void createControls(GuiParent gui, CreativeIngredient info) {
                gui.add((GuiControl)new GuiLabel(gui, "info").setTitle((Component)Component.literal((String)"Nothing to select")));
            }

            @Override
            public boolean canHandle(CreativeIngredient info) {
                return info instanceof CreativeIngredientFuel;
            }
        });
    }

    public static class GuiDataCheckList
    extends GuiCheckList<DataComponentType<?>> {
        public List<Identifier> included;

        public GuiDataCheckList(IGuiParent parent, String name, boolean modifiable, TextMapBuilder<DataComponentType<?>> map, List<Identifier> included) {
            super(parent, name, modifiable, map, null);
            this.included = included;
        }

        public boolean includes(DataComponentType<?> type) {
            return this.included.contains(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(type));
        }

        public List<Identifier> getConfiguredIncluded() {
            ArrayList<Identifier> included = new ArrayList<Identifier>();
            for (GuiCheckList.GuiCheckListRow row : this.rows) {
                if (!row.checkBox.get()) continue;
                included.add(BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)row.value)));
            }
            return included;
        }
    }
}

