/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.dialog;

import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.flow.GuiFlow;

public class DialogGuiLayer
extends GuiLayer {
    public DialogButton[] buttons;
    public BiConsumer<DialogGuiLayer, DialogButton> onClicked;
    public Component title;

    public DialogGuiLayer(boolean client, String name, Component title, BiConsumer<DialogGuiLayer, DialogButton> onClicked, DialogButton ... buttons) {
        super(client, name);
        this.title = title;
        this.buttons = buttons;
        this.onClicked = onClicked;
        this.setAlign(Align.CENTER);
        this.setVAlign(VAlign.CENTER);
        this.setFlow(GuiFlow.STACK_Y);
    }

    @Override
    public void create() {
        this.add((GuiControl)new GuiLabel(this, "text").setTitle(this.title));
        GuiParent hBox = new GuiParent((IGuiParent)this, GuiFlow.STACK_X);
        for (DialogButton button : this.buttons) {
            hBox.add((GuiControl)new GuiButton(this, button.name(), x -> this.closeDialog(button)).setTitle((Component)Component.translatable((String)("dialog.button." + button.name()))));
        }
        this.add((GuiControl)hBox);
    }

    public void closeDialog(DialogButton button) {
        this.closeTopLayer();
        this.onClicked.accept(this, button);
    }

    public static enum DialogButton {
        OK,
        YES,
        NO,
        MAYBE,
        CANCEL,
        ABORT,
        CONFIRM;

    }
}

