/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.control.simple;

import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.parent.GuiColumn;
import team.creative.creativecore.common.gui.control.parent.GuiRow;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiButtonHold;
import team.creative.creativecore.common.gui.control.simple.GuiColorPlate;
import team.creative.creativecore.common.gui.control.simple.GuiColoredSteppedSlider;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.creativecore.common.util.type.Color;

public class GuiColorPicker
extends GuiParent {
    protected GuiColoredSteppedSlider r;
    protected GuiColoredSteppedSlider g;
    protected GuiColoredSteppedSlider b;
    protected GuiColoredSteppedSlider a;
    protected GuiHexButton hex;
    public Color color;

    public GuiColorPicker(IGuiParent parent, String name, Color color, boolean hasAlpha, int alphaMin) {
        super(parent, name);
        this.color = new Color(color);
        GuiRow row = new GuiRow(this);
        this.add((GuiControl)row);
        GuiColumn sliders = new GuiColumn((IGuiParent)this, GuiFlow.STACK_Y);
        sliders.setSpacing(-1);
        row.addColumn(sliders);
        GuiParent red = new GuiParent((IGuiParent)this, GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
        sliders.add((GuiControl)red);
        red.add(new GuiButtonHold(red, "r-", x -> this.r.stepDown()).setTitle((Component)Component.literal((String)"<")).setFormatting(ControlFormatting.TRANSPARENT));
        this.r = (GuiColoredSteppedSlider)new GuiColoredSteppedSlider(red, "r", this, ColorUtils.ColorPart.RED).setExpandableX();
        red.add((GuiControl)this.r);
        red.add(new GuiButtonHold(red, "r+", x -> this.r.stepUp()).setTitle((Component)Component.literal((String)">")).setFormatting(ControlFormatting.TRANSPARENT));
        GuiParent green = new GuiParent((IGuiParent)this, GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
        sliders.add((GuiControl)green);
        green.add(new GuiButtonHold(green, "g-", x -> this.g.stepDown()).setTitle((Component)Component.literal((String)"<")).setFormatting(ControlFormatting.TRANSPARENT));
        this.g = (GuiColoredSteppedSlider)new GuiColoredSteppedSlider(green, "g", this, ColorUtils.ColorPart.GREEN).setExpandableX();
        green.add((GuiControl)this.g);
        green.add(new GuiButtonHold(green, "g+", x -> this.g.stepUp()).setTitle((Component)Component.literal((String)">")).setFormatting(ControlFormatting.TRANSPARENT));
        GuiParent blue = new GuiParent((IGuiParent)this, GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
        sliders.add((GuiControl)blue);
        blue.add(new GuiButtonHold(blue, "b-", x -> this.b.stepDown()).setTitle((Component)Component.literal((String)"<")).setFormatting(ControlFormatting.TRANSPARENT));
        this.b = (GuiColoredSteppedSlider)new GuiColoredSteppedSlider(blue, "b", this, ColorUtils.ColorPart.BLUE).setExpandableX();
        blue.add((GuiControl)this.b);
        blue.add(new GuiButtonHold(blue, "b+", x -> this.b.stepUp()).setTitle((Component)Component.literal((String)">")).setFormatting(ControlFormatting.TRANSPARENT));
        if (hasAlpha) {
            GuiParent alpha = new GuiParent((IGuiParent)this, GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
            sliders.add((GuiControl)alpha);
            alpha.add(new GuiButtonHold(alpha, "a-", x -> this.a.stepDown()).setTitle((Component)Component.literal((String)"<")).setFormatting(ControlFormatting.TRANSPARENT));
            this.a = (GuiColoredSteppedSlider)new GuiColoredSteppedSlider(alpha, "a", this, ColorUtils.ColorPart.ALPHA).setExpandableX();
            alpha.add((GuiControl)this.a);
            alpha.add(new GuiButtonHold(alpha, "a+", x -> this.a.stepUp()).setTitle((Component)Component.literal((String)">")).setFormatting(ControlFormatting.TRANSPARENT));
        } else {
            this.color.setAlpha(255);
        }
        GuiColumn plate = new GuiColumn((IGuiParent)this, 30, (GuiFlow)GuiFlow.STACK_Y);
        plate.setAlign(Align.CENTER).setVAlign(VAlign.CENTER);
        row.addColumn(plate);
        plate.add(new GuiColorPlate(plate, "plate", this.color).setDim(20, 20));
        this.hex = new GuiHexButton(plate, this, name, hex -> {
            if (hex.intValue() != this.color.toInt()) {
                this.r.setValueSilent(ColorUtils.red(hex));
                this.g.setValueSilent(ColorUtils.green(hex));
                this.b.setValueSilent(ColorUtils.blue(hex));
                this.onColorChanged(false);
            }
        });
        plate.add((GuiControl)this.hex);
    }

    public void setColor(Color color) {
        this.r.setValueSilent(color.getRed());
        this.g.setValueSilent(color.getGreen());
        this.b.setValueSilent(color.getBlue());
        if (this.a != null) {
            this.a.setValueSilent(color.getAlpha());
        }
        this.onColorChanged(true);
    }

    public void onColorChanged(boolean notifyHex) {
        if (notifyHex) {
            this.hex.colorChanged();
        }
        this.raiseEvent(new GuiControlChangedEvent<GuiColorPicker>(this));
    }

    public static class GuiHexButton
    extends GuiButton {
        public GuiHexButton(IGuiParent parent, GuiColorPicker picker, String name, Consumer<Integer> consumer) {
            super(parent, name, null);
            if (this.dist() != null) {
                this.dist().setConsumer(picker, consumer);
            }
            this.setTitle((Component)Component.literal((String)"#"));
        }

        @Override
        public GuiHexButtonDist dist() {
            return (GuiHexButtonDist)super.dist();
        }

        public void colorChanged() {
            if (this.dist() != null) {
                this.dist().colorChanged();
            }
        }
    }

    public static interface GuiHexButtonDist
    extends GuiButton.GuiButtonDist {
        public void setConsumer(GuiColorPicker var1, Consumer<Integer> var2);

        public void colorChanged();
    }
}

