/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.config.gui;

import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.config.gui.GuiPlayerSelectorButton;
import team.creative.creativecore.common.config.gui.GuiPlayerSelectorHandler;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.player.PlayerSelector;
import team.creative.creativecore.common.util.text.TextMapBuilder;

public class PlayerSelectorDialog
extends GuiLayer {
    public GuiParent settings;
    public GuiPlayerSelectorButton button;
    public GuiPlayerSelectorHandler handler;

    public PlayerSelectorDialog(boolean client) {
        super(client, "playerselector", 150, 150);
        this.registerEventChanged(event -> {
            if (event.control.is("type")) {
                GuiComboBox box = (GuiComboBox)event.control;
                this.settings.clear();
                this.handler = (GuiPlayerSelectorHandler)box.selected();
                this.handler.createControls(this.settings, this.button.get());
                this.reflow();
            } else {
                this.handler.onChanged(this, (GuiControlChangedEvent)event);
            }
        });
        this.setFlow(GuiFlow.STACK_Y);
    }

    @Override
    public void create() {
        if (this.button == null) {
            return;
        }
        PlayerSelector selector = this.button.get();
        this.handler = GuiPlayerSelectorHandler.get(selector);
        GuiComboBox<GuiPlayerSelectorHandler> box = new GuiComboBox<GuiPlayerSelectorHandler>(this, "type", new TextMapBuilder<GuiPlayerSelectorHandler>().addComponent(GuiPlayerSelectorHandler.REGISTRY.values(), x -> Component.literal((String)x.getName())));
        this.add(box.setExpandableX());
        this.settings = new GuiParent((IGuiParent)this, GuiFlow.STACK_Y);
        this.add((GuiControl)this.settings);
        this.settings.setExpandable();
        GuiLeftRightBox bottom = new GuiLeftRightBox(this);
        this.add((GuiControl)bottom);
        bottom.addLeft(new GuiButton(bottom, "Cancel", x -> this.closeTopLayer()).setTranslate("gui.cancel"));
        bottom.addRight(new GuiButton(bottom, "Save", x -> {
            Object parsed = this.handler.parseSelector(this);
            if (parsed != null) {
                this.button.set((PlayerSelector)parsed);
                this.closeTopLayer();
            }
        }).setTranslate("gui.save"));
        box.select(this.handler);
    }
}

