/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.client.gui.control.collection;

import java.util.ArrayList;
import net.minecraft.client.input.MouseButtonInfo;
import team.creative.creativecore.client.gui.control.collection.GuiClientComboBox;
import team.creative.creativecore.client.gui.control.collection.GuiClientListBoxBase;
import team.creative.creativecore.client.gui.control.simple.GuiClientLabel;
import team.creative.creativecore.client.gui.extension.GuiExtensionCreator;
import team.creative.creativecore.client.render.text.CompiledText;
import team.creative.creativecore.common.gui.IGuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiComboBoxExtension;
import team.creative.creativecore.common.gui.control.simple.GuiListEntry;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;

public class GuiClientComboBoxExtension<T extends GuiComboBoxExtension>
extends GuiClientListBoxBase<T> {
    private GuiExtensionCreator<? extends GuiClientComboBox<?, ?>, ? extends GuiComboBoxExtension> creator;
    public String search = "";

    public GuiClientComboBoxExtension(T control) {
        super(control);
    }

    public void init(GuiExtensionCreator<? extends GuiClientComboBox<?, ?>, ? extends GuiComboBoxExtension> creator) {
        this.creator = creator;
        ((GuiComboBoxExtension)this.control).registerEventChanged(event -> {
            if (event.control.is("searchBar")) {
                this.search = ((GuiTextfield)event.control).getText();
                this.reloadControls();
            }
        });
        this.reloadControls();
    }

    public GuiExtensionCreator<? extends GuiClientComboBox<?, ?>, ? extends GuiComboBoxExtension> creator() {
        return this.creator;
    }

    @Override
    public void looseFocus() {
        this.creator.markLostFocus();
    }

    public void reloadControls() {
        GuiClientComboBox box;
        if (this.creator == null) {
            return;
        }
        GuiTextfield textfield = (GuiTextfield)((GuiComboBoxExtension)this.control).get("searchBar");
        ((GuiComboBoxExtension)this.control).clearItems();
        if (this.search != null && this.search.isBlank()) {
            this.search = null;
        }
        if ((box = (GuiClientComboBox)this.creator.parent).hasSearchbar()) {
            if (textfield == null) {
                textfield = new GuiTextfield((IGuiParent)((Object)this.control), "searchBar", this.search == null ? "" : this.search);
                ((GuiComboBoxExtension)this.control).addCustomControl(textfield.setExpandableX());
            }
            textfield.dist().focus();
        }
        ArrayList<GuiListEntry> entries = new ArrayList<GuiListEntry>();
        int i = 0;
        for (CompiledText text : box.lines()) {
            if (this.search == null || text.contains(this.search)) {
                int index = i;
                GuiListEntry label = new GuiListEntry((IGuiParent)((Object)this.control), "" + i, i, i == box.selectedIndex(), x -> {
                    ((GuiClientComboBox)this.creator.parent).select(index, true);
                    this.creator.close();
                });
                ((GuiClientLabel)label.dist()).setText(text.copy());
                entries.add(label);
            }
            ++i;
        }
        ((GuiComboBoxExtension)this.control).addAllItems(entries);
        if (((GuiComboBoxExtension)this.control).hasGui()) {
            this.reflowInternal();
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, MouseButtonInfo info) {
        if (super.mouseClicked(x, y, info)) {
            this.creator.markKeptFocus();
            return true;
        }
        return false;
    }

    @Override
    protected int maxHeight(int width, int availableWidth) {
        return 100;
    }
}

