/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.network.message.configuration;

import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.api.network.ConfigurationMessageContext;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import com.mrcrayfish.framework.network.FrameworkCodecs;
import com.mrcrayfish.framework.network.message.ConfigurationMessage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import org.apache.commons.lang3.tuple.Pair;

public record S2CSyncedEntityData(Map<Identifier, List<Pair<Identifier, Integer>>> keyMap) {
    public static final StreamCodec<FriendlyByteBuf, S2CSyncedEntityData> STREAM_CODEC = StreamCodec.composite(FrameworkCodecs.ENTITY_DATA_KEYS, S2CSyncedEntityData::keyMap, S2CSyncedEntityData::new);

    public static void handle(S2CSyncedEntityData message, ConfigurationMessageContext context) {
        Constants.LOG.debug(ConfigurationMessage.MARKER, "Receiving synced entity keys from server");
        boolean[] failed = new boolean[1];
        CountDownLatch block = new CountDownLatch(1);
        context.execute(() -> {
            if (!SyncedEntityData.instance().updateMappings(message)) {
                failed[0] = true;
            }
            block.countDown();
        });
        try {
            block.await();
        }
        catch (InterruptedException e) {
            failed[0] = true;
        }
        if (failed[0]) {
            context.disconnect((Component)Component.translatable((String)"framework.gui.sync_entity_data_failed"));
        }
    }

    public Map<Identifier, List<Pair<Identifier, Integer>>> getKeyMap() {
        return this.keyMap;
    }
}

