/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.registry;

import com.mrcrayfish.framework.registry.RegistryProxy;
import com.mrcrayfish.framework.registry.VanillaRegistryProxy;
import java.util.Iterator;
import net.minecraft.core.Registry;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrappedRegistry<T>
implements Iterable<T> {
    private final ResourceKey<Registry<T>> key;
    @Nullable
    private RegistryProxy<T> proxy;

    public WrappedRegistry(ResourceKey<Registry<T>> key) {
        this.key = key;
    }

    public ResourceKey<Registry<T>> getKey() {
        return this.key;
    }

    public boolean containsKey(Identifier id) {
        return this.getProxy().containsKey(id);
    }

    @Nullable
    public T getValue(Identifier id) {
        return this.getProxy().getValue(id);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.getProxy().iterable().iterator();
    }

    @ApiStatus.Internal
    RegistryProxy<T> getProxy() {
        if (this.proxy == null) {
            throw new IllegalStateException("Registry not created yet");
        }
        return this.proxy;
    }

    @ApiStatus.Internal
    public void setProxy(RegistryProxy<?> registry) {
        this.proxy = registry;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @ApiStatus.Internal
    public static <T> WrappedRegistry<T> wrapVanilla(Registry<@NotNull T> registry) {
        @NotNull @NotNull ResourceKey key = ResourceKey.createRegistryKey((Identifier)registry.key().identifier());
        WrappedRegistry<T> wrapped = new WrappedRegistry<T>(key);
        wrapped.proxy = VanillaRegistryProxy.wrap(registry);
        return wrapped;
    }
}

