/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.registry;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mrcrayfish.framework.api.menu.IMenuData;
import com.mrcrayfish.framework.api.registry.BlockRegistryEntry;
import com.mrcrayfish.framework.api.registry.CustomStatRegistryEntry;
import com.mrcrayfish.framework.api.registry.FrameworkRegistry;
import com.mrcrayfish.framework.api.registry.WrappedRegistry;
import com.mrcrayfish.framework.platform.Services;
import com.mrcrayfish.framework.registry.RegisterConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.StatFormatter;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.ApiStatus;

public sealed class RegistryEntry<T>
permits BlockRegistryEntry, CustomStatRegistryEntry {
    protected final WrappedRegistry<T> registry;
    protected final Identifier valueId;
    protected final Supplier<T> valueSupplier;
    private T instance;
    private Holder<T> holder;

    RegistryEntry(Registry<?> registry, Identifier valueId, Supplier<T> valueSupplier) {
        this(WrappedRegistry.wrapVanilla(registry), valueId, valueSupplier);
    }

    RegistryEntry(WrappedRegistry<T> registry, Identifier valueId, Supplier<T> valueSupplier) {
        this.registry = registry;
        this.valueId = valueId;
        this.valueSupplier = valueSupplier;
    }

    public T get() {
        if (this.instance == null) {
            throw new IllegalStateException("Entry has not been created yet");
        }
        return this.instance;
    }

    public Holder<T> holder() {
        if (this.holder == null) {
            throw new IllegalStateException("Entry has not been created yet");
        }
        return this.holder;
    }

    protected T create() {
        if (this.instance != null) {
            throw new IllegalStateException("Entry has already been created");
        }
        this.instance = this.valueSupplier.get();
        return this.instance;
    }

    public ResourceKey<Registry<T>> getRegistryKey() {
        return this.registry.getKey();
    }

    public Identifier getId() {
        return this.valueId;
    }

    protected void invalidate() {
        this.instance = null;
        this.holder = null;
    }

    @ApiStatus.Internal
    public void register(RegisterConsumer<T> consumer) {
        this.invalidate();
        Object value = this.create();
        consumer.accept(this.registry.getKey(), this.valueId, () -> value);
        this.holder = this.registry.getProxy().getHolder(this.valueId);
    }

    public static <T> RegistryEntry<T> custom(FrameworkRegistry registry, Identifier id, Supplier<T> supplier) {
        return new RegistryEntry<T>(registry, id, supplier);
    }

    public static <T extends Attribute> RegistryEntry<T> attribute(Identifier id, Supplier<T> attributeFactory) {
        return new RegistryEntry<T>(BuiltInRegistries.ATTRIBUTE, id, attributeFactory);
    }

    public static <T extends Block> RegistryEntry<T> block(Identifier id, Function<BlockBehaviour.Properties, T> blockFactory, Supplier<BlockBehaviour.Properties> blockPropertiesFactory) {
        return new BlockRegistryEntry<Block, BlockItem>((Registry<?>)BuiltInRegistries.BLOCK, id, () -> {
            BlockBehaviour.Properties properties = (BlockBehaviour.Properties)blockPropertiesFactory.get();
            return (Block)blockFactory.apply(properties.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)id)));
        }, t -> null);
    }

    public static <T extends Block> RegistryEntry<T> blockWithItem(Identifier id, Function<BlockBehaviour.Properties, T> blockFactory, Supplier<BlockBehaviour.Properties> blockPropertiesFactory) {
        return new BlockRegistryEntry<Block, BlockItem>((Registry<?>)BuiltInRegistries.BLOCK, id, () -> {
            BlockBehaviour.Properties properties = (BlockBehaviour.Properties)blockPropertiesFactory.get();
            return (Block)blockFactory.apply(properties.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)id)));
        }, t -> new BlockItem(t, new Item.Properties().useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (Identifier)id))));
    }

    public static <T extends Block, E extends BlockItem> RegistryEntry<T> blockWithItem(Identifier id, Function<BlockBehaviour.Properties, T> blockFactory, Supplier<BlockBehaviour.Properties> blockPropertiesFactory, BiFunction<T, Item.Properties, E> itemFactory, Supplier<Item.Properties> itemPropertiesFactory) {
        return new BlockRegistryEntry<Block, BlockItem>((Registry<?>)BuiltInRegistries.BLOCK, id, () -> {
            BlockBehaviour.Properties blockProperties = (BlockBehaviour.Properties)blockPropertiesFactory.get();
            return (Block)blockFactory.apply(blockProperties.setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)id)));
        }, t -> {
            Item.Properties itemProperties = (Item.Properties)itemPropertiesFactory.get();
            return (BlockItem)itemFactory.apply(t, itemProperties.useBlockDescriptionPrefix().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (Identifier)id)));
        });
    }

    public static <T extends BlockEntity> RegistryEntry<BlockEntityType<T>> blockEntity(Identifier id, BiFunction<BlockPos, BlockState, T> blockEntityFactory, Supplier<Block[]> validBlocks) {
        return new RegistryEntry<BlockEntityType<T>>(BuiltInRegistries.BLOCK_ENTITY_TYPE, id, () -> Services.REGISTRATION.createBlockEntityType(blockEntityFactory, validBlocks));
    }

    public static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>, I extends ArgumentTypeInfo<A, T>> RegistryEntry<I> commandArgumentType(Identifier id, Class<A> argumentTypeClass, Supplier<I> argumentTypeFactory) {
        return new RegistryEntry<ArgumentTypeInfo>(BuiltInRegistries.COMMAND_ARGUMENT_TYPE, id, () -> Services.REGISTRATION.createArgumentTypeInfo(argumentTypeClass, argumentTypeFactory));
    }

    public static RegistryEntry<CreativeModeTab> creativeModeTab(Identifier id, Consumer<CreativeModeTab.Builder> builderConsumer) {
        return new RegistryEntry<CreativeModeTab>(BuiltInRegistries.CREATIVE_MODE_TAB, id, () -> {
            CreativeModeTab.Builder builder = Services.REGISTRATION.createCreativeModeTabBuilder();
            builderConsumer.accept(builder);
            return builder.build();
        });
    }

    public static RegistryEntry<Identifier> customStat(Identifier id, StatFormatter formatter) {
        return new CustomStatRegistryEntry(BuiltInRegistries.CUSTOM_STAT, id, formatter);
    }

    public static <T> RegistryEntry<DataComponentType<T>> dataComponentType(Identifier id, UnaryOperator<DataComponentType.Builder<T>> builderOperator) {
        return new RegistryEntry<DataComponentType<T>>(BuiltInRegistries.DATA_COMPONENT_TYPE, id, () -> ((DataComponentType.Builder)builderOperator.apply(DataComponentType.builder())).build());
    }

    public static <T> RegistryEntry<DataComponentType<T>> enchantmentEffectComponentType(Identifier id, UnaryOperator<DataComponentType.Builder<T>> builderOperator) {
        return new RegistryEntry<DataComponentType<T>>(BuiltInRegistries.ENCHANTMENT_EFFECT_COMPONENT_TYPE, id, () -> ((DataComponentType.Builder)builderOperator.apply(DataComponentType.builder())).build());
    }

    public static <T extends Entity> RegistryEntry<EntityType<T>> entityType(Identifier id, Supplier<EntityType.Builder<T>> entityTypeFactory) {
        return new RegistryEntry<EntityType<T>>((Registry<?>)BuiltInRegistries.ENTITY_TYPE, id, () -> ((EntityType.Builder)entityTypeFactory.get()).build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (Identifier)id)));
    }

    public static <T extends Fluid> RegistryEntry<T> fluid(Identifier id, Supplier<T> fluidFactory) {
        return new RegistryEntry<T>((Registry<?>)BuiltInRegistries.FLUID, id, fluidFactory);
    }

    public static <T extends Item> RegistryEntry<T> item(Identifier id, Function<Item.Properties, T> itemFactory, Supplier<Item.Properties> itemPropertiesFactory) {
        return new RegistryEntry<Item>((Registry<?>)BuiltInRegistries.ITEM, id, () -> {
            Item.Properties itemProperties = (Item.Properties)itemPropertiesFactory.get();
            return (Item)itemFactory.apply(itemProperties.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (Identifier)id)));
        });
    }

    public static <T extends AbstractContainerMenu> RegistryEntry<MenuType<T>> menuType(Identifier id, BiFunction<Integer, Inventory, T> menuFactory) {
        return new RegistryEntry<MenuType<T>>(BuiltInRegistries.MENU, id, () -> Services.REGISTRATION.createMenuType(menuFactory));
    }

    public static <T extends AbstractContainerMenu, D extends IMenuData<D>> RegistryEntry<MenuType<T>> menuTypeWithData(Identifier id, StreamCodec<RegistryFriendlyByteBuf, D> dataCodec, TriFunction<Integer, Inventory, D, T> menuFactory) {
        return new RegistryEntry<MenuType<T>>(BuiltInRegistries.MENU, id, () -> Services.REGISTRATION.createMenuTypeWithData(dataCodec, menuFactory));
    }

    public static <T extends MobEffect> RegistryEntry<T> mobEffect(Identifier id, Supplier<T> mobEffectFactory) {
        return new RegistryEntry<T>(BuiltInRegistries.MOB_EFFECT, id, mobEffectFactory);
    }

    public static <T extends ParticleType<?>> RegistryEntry<T> particleType(Identifier id, Supplier<T> particleTypeFactory) {
        return new RegistryEntry<T>(BuiltInRegistries.PARTICLE_TYPE, id, particleTypeFactory);
    }

    public static <T extends Potion> RegistryEntry<T> potion(Identifier id, Supplier<T> potionFactory) {
        return new RegistryEntry<T>(BuiltInRegistries.POTION, id, potionFactory);
    }

    public static <T extends RecipeDisplay, D extends RecipeDisplay.Type<T>> RegistryEntry<D> recipeDisplay(Identifier id, Supplier<D> recipeDisplayFactory) {
        return new RegistryEntry<D>(BuiltInRegistries.RECIPE_DISPLAY, id, recipeDisplayFactory);
    }

    public static RegistryEntry<RecipeBookCategory> recipeBookCategory(Identifier id) {
        return new RegistryEntry<RecipeBookCategory>(BuiltInRegistries.RECIPE_BOOK_CATEGORY, id, RecipeBookCategory::new);
    }

    public static <T extends Recipe<?>> RegistryEntry<RecipeType<T>> recipeType(final Identifier id) {
        return new RegistryEntry<RecipeType<T>>(BuiltInRegistries.RECIPE_TYPE, id, () -> new RecipeType<T>(){

            public String toString() {
                return id.getPath();
            }
        });
    }

    public static <T extends RecipeSerializer<?>> RegistryEntry<T> recipeSerializer(Identifier id, Supplier<T> recipeSerializerFactory) {
        return new RegistryEntry<T>(BuiltInRegistries.RECIPE_SERIALIZER, id, recipeSerializerFactory);
    }

    public static <T extends SoundEvent> RegistryEntry<T> soundEvent(Identifier id, Function<Identifier, Supplier<T>> soundEventFactory) {
        return new RegistryEntry<T>(BuiltInRegistries.SOUND_EVENT, id, soundEventFactory.apply(id));
    }
}

