/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.datagen;

import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mrcrayfish.framework.api.datagen.FrameworkGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.renderer.block.model.BlockModelDefinition;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

@Beta
public class FrameworkModelProvider
implements DataProvider {
    private final PackOutput.PathProvider blockstates;
    private final PackOutput.PathProvider items;
    private final PackOutput.PathProvider models;
    private final FrameworkGenerator.Factory<? extends FrameworkGenerator>[] generators;

    public FrameworkModelProvider(PackOutput output, FrameworkGenerator.Factory<? extends FrameworkGenerator> ... generators) {
        this.blockstates = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        this.items = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "items");
        this.models = output.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        this.generators = generators;
    }

    public CompletableFuture<?> run(CachedOutput output) {
        HashMap<Block, BlockModelDefinitionGenerator> generators = new HashMap<Block, BlockModelDefinitionGenerator>();
        HashMap<Item, ClientItem> clientItems = new HashMap<Item, ClientItem>();
        HashMap<Identifier, ModelInstance> models = new HashMap<Identifier, ModelInstance>();
        for (FrameworkGenerator.Factory<? extends FrameworkGenerator> generator : this.generators) {
            generator.apply(generators, clientItems, models).generate();
        }
        CompletableFuture[] completableFutureArray = new CompletableFuture[3];
        completableFutureArray[0] = DataProvider.saveAll((CachedOutput)output, (Codec)BlockModelDefinition.CODEC, block -> this.blockstates.json(block.builtInRegistryHolder().key().identifier()), (Map)Maps.transformValues(generators, BlockModelDefinitionGenerator::create));
        completableFutureArray[1] = DataProvider.saveAll((CachedOutput)output, (Codec)ClientItem.CODEC, item -> this.items.json(item.builtInRegistryHolder().key().identifier()), clientItems);
        completableFutureArray[2] = DataProvider.saveAll((CachedOutput)output, Supplier::get, arg_0 -> ((PackOutput.PathProvider)this.models).json(arg_0), models);
        return CompletableFuture.allOf(completableFutureArray);
    }

    public String getName() {
        return "Model Definitions";
    }
}

