/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.datagen;

import com.google.common.annotations.Beta;
import java.util.Map;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

@Beta
public abstract class FrameworkGenerator {
    protected final Map<Block, BlockModelDefinitionGenerator> generators;
    protected final Map<Item, ClientItem> items;
    protected final Map<Identifier, ModelInstance> models;

    public FrameworkGenerator(Map<Block, BlockModelDefinitionGenerator> generators, Map<Item, ClientItem> items, Map<Identifier, ModelInstance> models) {
        this.generators = generators;
        this.items = items;
        this.models = models;
    }

    public abstract void generate();

    protected void customItemModel(Item item) {
        this.items.put(item, this.createClientItem(ItemModelUtils.plainModel((Identifier)ModelLocationUtils.getModelLocation((Item)item))));
    }

    protected void flatItemModel(Item item) {
        this.items.put(item, this.createClientItem(ItemModelUtils.plainModel((Identifier)ModelTemplates.FLAT_ITEM.create(item, TextureMapping.layer0((Item)item), this.models::put))));
    }

    protected ClientItem createClientItem(ItemModel.Unbaked model) {
        return new ClientItem(model, ClientItem.Properties.DEFAULT);
    }

    @FunctionalInterface
    public static interface Factory<T extends FrameworkGenerator> {
        public T apply(Map<Block, BlockModelDefinitionGenerator> var1, Map<Item, ClientItem> var2, Map<Identifier, ModelInstance> var3);
    }
}

