/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.config.validate;

import com.google.common.base.Preconditions;
import com.mrcrayfish.framework.api.config.validate.Validator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.Nullable;

public final class IdentifierValidator
implements Validator<String> {
    private static final IdentifierValidator INSTANCE = new IdentifierValidator(null);
    @Nullable
    private final String namespace;
    private final Component hint;

    private IdentifierValidator(@Nullable String namespace) {
        this.namespace = namespace;
        this.hint = namespace != null ? Component.translatable((String)"framework.validator.resource_location.hint_with_namespace", (Object[])new Object[]{namespace}) : Component.translatable((String)"framework.validator.resource_location.hint");
    }

    @Override
    public boolean test(String value) {
        Identifier result = Identifier.tryParse((String)value);
        return result != null && (this.namespace == null || this.namespace.equals(result.getNamespace()));
    }

    @Override
    public Component getHint() {
        return this.hint;
    }

    @Override
    public String getCommentHint() {
        if (this.namespace != null) {
            return "Valid value: A valid resource location but must use the namespace \"%1$s\". Format: \"%1$s:<path>\"".formatted(this.namespace);
        }
        return "Valid value: Any valid resource location. Format: \"<namespace>:<path>\"";
    }

    public static IdentifierValidator any() {
        return INSTANCE;
    }

    public static IdentifierValidator restrictNamespace(String namespace) {
        Preconditions.checkState((boolean)Identifier.isValidNamespace((String)namespace), (String)"Invalid namespace: %s", (Object)namespace);
        return new IdentifierValidator(namespace);
    }
}

