/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.model;

import com.mrcrayfish.framework.api.client.model.FrameworkModelBaker;
import com.mrcrayfish.framework.api.client.model.FrameworkModelResource;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.client.resources.model.ResolvedModel;
import net.minecraft.resources.Identifier;
import net.neoforged.neoforge.client.model.standalone.StandaloneModelKey;
import net.neoforged.neoforge.client.model.standalone.UnbakedStandaloneModel;
import org.jetbrains.annotations.NotNull;

public class NeoForgeModelResource<T>
extends FrameworkModelResource<T> {
    private final StandaloneModelKey<@NotNull T> key = new StandaloneModelKey(() -> ((Identifier)location).toString());
    private final UnbakedStandaloneModel<@NotNull T> baker;

    public NeoForgeModelResource(final Identifier location, final FrameworkModelBaker<T> modelBaker) {
        super(location, modelBaker);
        this.baker = new UnbakedStandaloneModel<T>(this){

            public T bake(ModelBaker baker) {
                ResolvedModel resolvedModel = baker.getModel(location);
                return modelBaker.bake(resolvedModel, baker);
            }

            public void resolveDependencies(ResolvableModel.Resolver resolver) {
                resolver.markDependency(location);
            }
        };
    }

    public StandaloneModelKey<T> standaloneKey() {
        return this.key;
    }

    public UnbakedStandaloneModel<T> unbakedModel() {
        return this.baker;
    }
}

