/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.api.client.model;

import com.mrcrayfish.framework.api.client.model.FrameworkModelBaker;
import com.mrcrayfish.framework.api.serialize.DataObject;
import com.mrcrayfish.framework.client.model.IOpenModel;
import com.mrcrayfish.framework.platform.ClientServices;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.QuadCollection;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

public record FrameworkBakedModel(QuadCollection quads, boolean useAmbientOcclusion, TextureAtlasSprite particleIcon, ChunkSectionLayer layer, DataObject data) implements BlockModelPart,
IOpenModel
{
    public static final FrameworkModelBaker<FrameworkBakedModel> BAKER = (model, baker) -> {
        DataObject dataObject;
        boolean ambientOcclusion = model.getTopAmbientOcclusion();
        TextureSlots textureSlots = model.getTopTextureSlots();
        QuadCollection quads = model.bakeTopGeometry(textureSlots, baker, (ModelState)BlockModelRotation.IDENTITY);
        TextureAtlasSprite particle = model.resolveParticleSprite(textureSlots, baker);
        ChunkSectionLayer layer = ClientServices.CLIENT.getChunkSectionLayer(model);
        UnbakedModel patt0$temp = model.wrapped();
        if (patt0$temp instanceof IOpenModel) {
            IOpenModel openModel = (IOpenModel)patt0$temp;
            dataObject = openModel.getData();
        } else {
            dataObject = DataObject.EMPTY;
        }
        DataObject data = dataObject;
        return new FrameworkBakedModel(quads, ambientOcclusion, particle, layer, data);
    };

    public List<BakedQuad> getQuads(@Nullable Direction direction) {
        return this.quads.getQuads(direction);
    }

    @Override
    public DataObject getData() {
        return this.data;
    }
}

