/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework;

import com.mrcrayfish.framework.Constants;
import com.mrcrayfish.framework.FrameworkData;
import com.mrcrayfish.framework.FrameworkSetup;
import com.mrcrayfish.framework.Registration;
import com.mrcrayfish.framework.api.registry.BlockRegistryEntry;
import com.mrcrayfish.framework.api.registry.FrameworkRegistry;
import com.mrcrayfish.framework.entity.sync.DataHolder;
import com.mrcrayfish.framework.entity.sync.DataHolderSerializer;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import com.mrcrayfish.framework.event.NeoForgeEvents;
import com.mrcrayfish.framework.platform.Services;
import com.mrcrayfish.framework.platform.network.NeoForgeNetwork;
import com.mrcrayfish.framework.registry.VanillaRegistryProxy;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.network.ConfigurationTask;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.event.RegisterConfigurationTasksEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;

@Mod(value="framework")
public class FrameworkNeoForge {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)"framework");
    public static final Supplier<AttachmentType<DataHolder>> DATA_HOLDER = ATTACHMENT_TYPES.register("data_holder", () -> AttachmentType.builder(holder -> {
        if (holder instanceof Entity) {
            Entity entity = (Entity)holder;
            if (SyncedEntityData.instance().hasSyncedDataKey(entity)) {
                return new DataHolder(entity);
            }
        }
        return DataHolder.EMPTY;
    }).serialize((IAttachmentSerializer)new DataHolderSerializer()).build());

    public FrameworkNeoForge(IEventBus bus) {
        FrameworkSetup.run();
        bus.addListener(this::onCommonSetup);
        bus.addListener(this::onLoadComplete);
        bus.addListener(this::onRegister);
        bus.addListener(this::onRegisterPayloadHandler);
        bus.addListener(this::onRegisterGameConfigurations);
        bus.addListener(this::onRegisterNewRegistry);
        NeoForge.EVENT_BUS.register((Object)new NeoForgeEvents());
        ATTACHMENT_TYPES.register(bus);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(FrameworkSetup::init);
    }

    private void onRegister(RegisterEvent event) {
        Registration.get(event.getRegistryKey()).forEach(entry -> entry.register((arg_0, arg_1, arg_2) -> ((RegisterEvent)event).register(arg_0, arg_1, arg_2)));
        if (event.getRegistryKey().equals(Registries.ITEM)) {
            Registration.get(Registries.BLOCK).forEach(entry -> {
                if (entry instanceof BlockRegistryEntry) {
                    BlockRegistryEntry blockEntry = (BlockRegistryEntry)entry;
                    blockEntry.item().ifPresent(item -> event.register(Registries.ITEM, entry.getId(), () -> item));
                }
            });
        }
    }

    private void onLoadComplete(FMLLoadCompleteEvent event) {
        FrameworkData.setLoaded();
    }

    private void onRegisterPayloadHandler(RegisterPayloadHandlersEvent event) {
        Registration.getNetworks().forEach(network -> {
            PayloadRegistrar registrar = event.registrar(network.id().getNamespace());
            ((NeoForgeNetwork)network).registerPayloads(registrar);
        });
    }

    private void onRegisterGameConfigurations(RegisterConfigurationTasksEvent event) {
        Registration.getNetworks().forEach(network -> {
            NeoForgeNetwork neoForgeNetwork = (NeoForgeNetwork)network;
            neoForgeNetwork.getTasks().forEach(f -> event.register((ConfigurationTask)f.apply(neoForgeNetwork, event.getListener())));
        });
    }

    private void onRegisterNewRegistry(NewRegistryEvent event) {
        Services.REGISTRATION.getRegistryObjects(FrameworkRegistry.class).forEach(registry -> {
            Constants.LOG.debug("Registering custom registry: {}", (Object)registry.getKey().identifier());
            RegistryBuilder builder = new RegistryBuilder(registry.getKey()).sync(registry.shouldSync());
            registry.setProxy(VanillaRegistryProxy.wrap(event.create(builder)));
        });
    }
}

