/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.recipe.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.blay09.mods.littlejoys.api.EventCondition;
import net.blay09.mods.littlejoys.api.EventContext;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.state.BlockState;

public record AboveStateCondition(BlockState state) implements EventCondition
{
    public static final MapCodec<AboveStateCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("state").forGetter(AboveStateCondition::state)).apply((Applicative)instance, AboveStateCondition::new));

    @Override
    public boolean test(EventContext context) {
        BlockState groundState = context.level().getBlockState(context.pos().below());
        return groundState.equals((Object)this.state);
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeJsonWithCodec(BlockState.CODEC, (Object)this.state);
    }

    public static AboveStateCondition fromNetwork(FriendlyByteBuf buf) {
        BlockState state = (BlockState)buf.readLenientJsonWithCodec(BlockState.CODEC);
        return new AboveStateCondition(state);
    }
}

