/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.littlejoys.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.blay09.mods.littlejoys.entity.DropRushItemEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTable;

public final class DropRushInstance {
    private final UUID playerId;
    private final BlockPos pos;
    private final ResourceKey<LootTable> lootTable;
    private final int maxTicks;
    private final List<DropRushItemEntity> entities = new ArrayList<DropRushItemEntity>();
    private final List<ItemStack> drops = new ArrayList<ItemStack>();
    private int ticksPerDrop;
    private int ticksPassed;
    private int dropCooldownTicks;

    public DropRushInstance(UUID playerId, BlockPos pos, ResourceKey<LootTable> lootTable, int maxTicks) {
        this.playerId = playerId;
        this.pos = pos;
        this.lootTable = lootTable;
        this.maxTicks = maxTicks;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public int getTicksPerDrop() {
        return this.ticksPerDrop;
    }

    public void setTicksPerDrop(int ticksPerDrop) {
        this.ticksPerDrop = ticksPerDrop;
    }

    public int getTicksPassed() {
        return this.ticksPassed;
    }

    public void setTicksPassed(int ticksPassed) {
        this.ticksPassed = ticksPassed;
    }

    public int getDropCooldownTicks() {
        return this.dropCooldownTicks;
    }

    public void setDropCooldownTicks(int dropCooldownTicks) {
        this.dropCooldownTicks = dropCooldownTicks;
    }

    public void addDrop(ItemStack itemStack) {
        this.drops.add(itemStack);
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }

    public void addEntity(DropRushItemEntity entity) {
        this.entities.add(entity);
    }

    public List<DropRushItemEntity> getEntities() {
        return this.entities;
    }
}

