/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.compat;

import com.terraformersmc.biolith.api.biome.BiolithFittestNodes;
import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.compat.TerraBlenderCompat;
import com.terraformersmc.biolith.impl.surface.SurfaceRuleCollector;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.SurfaceRules;
import org.jetbrains.annotations.Nullable;
import terrablender.api.Region;
import terrablender.api.SurfaceRuleManager;
import terrablender.worldgen.IExtendedParameterList;

public class TerraBlenderCompatNeoForge
implements TerraBlenderCompat {
    @Override
    @Nullable
    public BiolithFittestNodes<Holder<Biome>> getBiome(int x, int y, int z, Climate.TargetPoint noisePoint, Climate.ParameterList<Holder<Biome>> biomeEntries) {
        if (!(biomeEntries instanceof IExtendedParameterList)) {
            return null;
        }
        IExtendedParameterList entries = (IExtendedParameterList)biomeEntries;
        if (!entries.isInitialized()) {
            return null;
        }
        Climate.RTree searchTree = entries.getTree(entries.getUniqueness(x, y, z));
        if (searchTree == null) {
            return null;
        }
        BiolithFittestNodes fittestNodes = searchTree.biolith$searchTreeGet(noisePoint, Climate.RTree.Node::distance);
        if (((Holder)fittestNodes.ultimate().value).is(Region.DEFERRED_PLACEHOLDER)) {
            searchTree = entries.getTree(0);
            fittestNodes = searchTree.biolith$searchTreeGet(noisePoint, Climate.RTree.Node::distance);
        }
        return fittestNodes;
    }

    @Override
    public void registerSurfaceRules() {
        Map.of(SurfaceRuleCollector.OVERWORLD, SurfaceRuleManager.RuleCategory.OVERWORLD, SurfaceRuleCollector.NETHER, SurfaceRuleManager.RuleCategory.NETHER, SurfaceRuleCollector.END, SurfaceRuleManager.RuleCategory.END).forEach((biolithRules, terrablenderRuleCategory) -> {
            if (biolithRules.getRuleCount() > 0) {
                for (Identifier ruleOwner : biolithRules.getRuleOwners()) {
                    String namespace = ruleOwner.getNamespace();
                    SurfaceRules.RuleSource rule = biolithRules.get(ruleOwner);
                    if (rule == null) continue;
                    if (namespace.equals("minecraft")) {
                        SurfaceRuleManager.addToDefaultSurfaceRulesAtStage((SurfaceRuleManager.RuleCategory)terrablenderRuleCategory, (SurfaceRuleManager.RuleStage)SurfaceRuleManager.RuleStage.BEFORE_BEDROCK, (int)0, (SurfaceRules.RuleSource)rule);
                        continue;
                    }
                    try {
                        SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)terrablenderRuleCategory, (String)namespace, (SurfaceRules.RuleSource)rule);
                    }
                    catch (IllegalArgumentException e) {
                        Biolith.LOGGER.debug("Exception: {}", (Object)e.getMessage());
                        Biolith.LOGGER.warn("Only one surface rule set per namespace can be registered with TerraBlender; dropping: {}", (Object)ruleOwner);
                    }
                }
            }
        });
    }
}

