/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.biolith.impl.biome;

import com.terraformersmc.biolith.impl.Biolith;
import com.terraformersmc.biolith.impl.biome.EndBiomePlacement;
import com.terraformersmc.biolith.impl.biome.NetherBiomePlacement;
import com.terraformersmc.biolith.impl.biome.OverworldBiomePlacement;
import com.terraformersmc.biolith.impl.compat.BiolithCompat;
import com.terraformersmc.biolith.impl.config.BiolithState;
import com.terraformersmc.biolith.impl.platform.Services;
import java.util.Optional;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import org.jetbrains.annotations.Nullable;

public class BiomeCoordinator {
    public static final EndBiomePlacement END = new EndBiomePlacement();
    public static final NetherBiomePlacement NETHER = new NetherBiomePlacement();
    public static final OverworldBiomePlacement OVERWORLD = new OverworldBiomePlacement();
    private static boolean registeredWithTerrablender = false;
    private static BiolithState END_STATE;
    private static BiolithState NETHER_STATE;
    private static BiolithState OVERWORLD_STATE;
    private static boolean serverStarted;
    protected static RegistryAccess.Frozen registryManager;

    public static boolean isServerStarted() {
        return serverStarted;
    }

    public static void setRegistryManager(LayeredRegistryAccess<RegistryLayer> combinedDynamicRegistries) {
        registryManager = combinedDynamicRegistries.compositeAccess();
    }

    @Nullable
    public static RegistryAccess.Frozen getRegistryManager() {
        return registryManager;
    }

    public static Optional<Registry<Biome>> getBiomeLookup() {
        if (registryManager == null) {
            return Optional.empty();
        }
        return registryManager.lookup(Registries.BIOME);
    }

    public static HolderGetter<Biome> getBiomeLookupOrThrow() {
        return (HolderGetter)BiomeCoordinator.getBiomeLookup().orElseThrow();
    }

    public static void handleServerStarting(MinecraftServer server) {
        if (registryManager == null) {
            registryManager = server.registries().compositeAccess();
        }
        if (BiolithCompat.COMPAT_TERRABLENDER && !registeredWithTerrablender) {
            Services.PLATFORM.getTerraBlenderCompat().registerSurfaceRules();
            registeredWithTerrablender = true;
        }
        if (serverStarted) {
            Biolith.LOGGER.warn("Received notification of server start-up but it should already be running!  O.o");
        } else {
            serverStarted = true;
        }
    }

    public static void handleWorldStarting(ServerLevel world) {
        Optional dimensionKey = world.dimensionTypeRegistration().unwrapKey();
        if (!serverStarted) {
            Biolith.LOGGER.error("New world '{}' created when server is not running!", (Object)world.dimension().identifier());
        }
        if (dimensionKey.isPresent()) {
            if (BuiltinDimensionTypes.END.equals(dimensionKey.get())) {
                if (END_STATE == null) {
                    END_STATE = (BiolithState)world.getDataStorage().computeIfAbsent(BiolithState.getPersistentStateType(world));
                    END.serverReplaced(END_STATE, world);
                } else {
                    Biolith.LOGGER.warn("More than one End dimension world created; cowardly ignoring '{}' in favor of '{}'", (Object)world.dimension().identifier(), (Object)END_STATE.getWorldId());
                }
            } else if (BuiltinDimensionTypes.NETHER.equals(dimensionKey.get())) {
                if (NETHER_STATE == null) {
                    NETHER_STATE = (BiolithState)world.getDataStorage().computeIfAbsent(BiolithState.getPersistentStateType(world));
                    NETHER.serverReplaced(NETHER_STATE, world);
                } else {
                    Biolith.LOGGER.warn("More than one Nether dimension world created; cowardly ignoring '{}' in favor of '{}'", (Object)world.dimension().identifier(), (Object)NETHER_STATE.getWorldId());
                }
            } else if (BuiltinDimensionTypes.OVERWORLD.equals(dimensionKey.get())) {
                if (OVERWORLD_STATE == null) {
                    OVERWORLD_STATE = (BiolithState)world.getDataStorage().computeIfAbsent(BiolithState.getPersistentStateType(world));
                    OVERWORLD.serverReplaced(OVERWORLD_STATE, world);
                } else {
                    Biolith.LOGGER.warn("More than one Overworld dimension world created; cowardly ignoring '{}' in favor of '{}'", (Object)world.dimension().identifier(), (Object)OVERWORLD_STATE.getWorldId());
                }
            } else {
                Biolith.LOGGER.info("Ignoring world '{}'; unknown dimension type: {}", (Object)world.dimension().identifier(), (Object)((ResourceKey)dimensionKey.get()).identifier());
            }
        } else {
            Biolith.LOGGER.info("Ignoring world '{}'; world has no associated dimension", (Object)world.dimension().identifier());
        }
    }

    public static void handleServerStopped(MinecraftServer server) {
        serverStarted = false;
        registryManager = null;
        END_STATE = null;
        NETHER_STATE = null;
        OVERWORLD_STATE = null;
        END.serverStopped();
        NETHER.serverStopped();
        OVERWORLD.serverStopped();
    }

    static {
        serverStarted = false;
    }
}

