/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.registries;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarBuilder;
import dev.architectury.registry.registries.forge.RegistrarManagerImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class RegistrarManager {
    private static final Map<String, RegistrarManager> MANAGER = new ConcurrentHashMap<String, RegistrarManager>();
    private final RegistryProvider provider;
    private final String modId;

    public static RegistrarManager get(String modId) {
        return MANAGER.computeIfAbsent(modId, RegistrarManager::new);
    }

    private RegistrarManager(String modId) {
        this.provider = RegistrarManager._get(modId);
        this.modId = modId;
    }

    public <T> Registrar<T> get(ResourceKey<Registry<T>> key) {
        return this.provider.get(key);
    }

    @Deprecated
    public <T> Registrar<T> get(Registry<T> registry) {
        return this.provider.get(registry);
    }

    public <T> void forRegistry(ResourceKey<Registry<T>> key, Consumer<Registrar<T>> callback) {
        this.provider.forRegistry(key, callback);
    }

    @SafeVarargs
    public final <T> RegistrarBuilder<T> builder(Identifier registryId, T ... typeGetter) {
        if (typeGetter.length != 0) {
            throw new IllegalStateException("array must be empty!");
        }
        return this.provider.builder(typeGetter.getClass().getComponentType(), registryId);
    }

    @Nullable
    public static <T> Identifier getId(T object, @Nullable ResourceKey<Registry<T>> fallback) {
        if (fallback == null) {
            return null;
        }
        return RegistrarManager.getId(object, (Registry)BuiltInRegistries.REGISTRY.getValue(fallback.identifier()));
    }

    @Deprecated
    @Nullable
    public static <T> Identifier getId(T object, @Nullable Registry<T> fallback) {
        if (fallback == null) {
            return null;
        }
        return fallback.getKey(object);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static RegistryProvider _get(String modId) {
        return RegistrarManagerImpl._get(modId);
    }

    public String getModId() {
        return this.modId;
    }

    @ApiStatus.Internal
    public static interface RegistryProvider {
        public <T> Registrar<T> get(ResourceKey<Registry<T>> var1);

        @Deprecated
        public <T> Registrar<T> get(Registry<T> var1);

        public <T> void forRegistry(ResourceKey<Registry<T>> var1, Consumer<Registrar<T>> var2);

        public <T> RegistrarBuilder<T> builder(Class<T> var1, Identifier var2);
    }
}

