/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.client;

import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.debug.DebugScreenDisplayer;
import net.minecraft.client.gui.components.debug.DebugScreenEntries;
import net.minecraft.client.gui.components.debug.DebugScreenEntry;
import net.minecraft.resources.Identifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;
import squeek.appleskin.helpers.HungerHelper;

public class DebugInfoHandler {
    private static final DecimalFormat saturationDF = new DecimalFormat("#.##");
    private static final DecimalFormat exhaustionValDF = new DecimalFormat("0.00");
    private static final DecimalFormat exhaustionMaxDF = new DecimalFormat("#.##");
    public static final Identifier SECTION_ID = Identifier.fromNamespaceAndPath((String)"appleskin", (String)"debug_info");

    public static void init() {
        DebugScreenEntries.register((Identifier)FoodStatsDebugEntry.ENTRY_ID, (DebugScreenEntry)new FoodStatsDebugEntry());
    }

    public static class FoodStatsDebugEntry
    implements DebugScreenEntry {
        public static final Identifier ENTRY_ID = Identifier.fromNamespaceAndPath((String)"appleskin", (String)"food_stats");

        public void display(DebugScreenDisplayer displayer, @Nullable Level level, @Nullable LevelChunk clientChunk, @Nullable LevelChunk serverChunk) {
            if (level != null) {
                Minecraft mc = Minecraft.getInstance();
                if (mc.player == null) {
                    return;
                }
                FoodData stats = mc.player.getFoodData();
                float curExhaustion = stats.exhaustionLevel;
                float maxExhaustion = HungerHelper.getMaxExhaustion((Player)mc.player);
                displayer.addToGroup(SECTION_ID, "hunger: " + stats.getFoodLevel() + ", sat: " + saturationDF.format(stats.getSaturationLevel()) + ", exh: " + exhaustionValDF.format(curExhaustion) + "/" + exhaustionMaxDF.format(maxExhaustion));
            }
        }
    }
}

