/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.audiodevice.SelectMicrophoneScreen;
import de.maxhenkel.voicechat.gui.audiodevice.SelectSpeakerScreen;
import de.maxhenkel.voicechat.gui.widgets.AgcButton;
import de.maxhenkel.voicechat.gui.widgets.DenoiserButton;
import de.maxhenkel.voicechat.gui.widgets.EnumButton;
import de.maxhenkel.voicechat.gui.widgets.KeybindButton;
import de.maxhenkel.voicechat.gui.widgets.MicActivationButton;
import de.maxhenkel.voicechat.gui.widgets.MicAmplificationSlider;
import de.maxhenkel.voicechat.gui.widgets.MicTestButton;
import de.maxhenkel.voicechat.gui.widgets.VadButton;
import de.maxhenkel.voicechat.gui.widgets.VoiceActivationSlider;
import de.maxhenkel.voicechat.gui.widgets.VoiceSoundSlider;
import de.maxhenkel.voicechat.natives.SpeexManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.client.speaker.AudioType;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;

public class VoiceChatSettingsScreen
extends VoiceChatScreenBase {
    private static final Identifier TEXTURE = Identifier.fromNamespaceAndPath((String)"voicechat", (String)"textures/gui/gui_voicechat_settings.png");
    private static final Component TITLE = Component.translatable((String)"gui.voicechat.voice_chat_settings.title");
    private static final Component ASSIGN_TOOLTIP = Component.translatable((String)"message.voicechat.press_to_reassign_key");
    private static final Component PUSH_TO_TALK = Component.translatable((String)"message.voicechat.activation_type.ptt");
    private static final Component SELECT_MICROPHONE = Component.translatable((String)"message.voicechat.select_microphone");
    private static final Component SELECT_SPEAKER = Component.translatable((String)"message.voicechat.select_speaker");
    private static final Component BACK = Component.translatable((String)"message.voicechat.back");
    @Nullable
    private final Screen parent;
    private VoiceActivationSlider voiceActivationSlider;
    private MicTestButton micTestButton;
    private KeybindButton keybindButton;

    public VoiceChatSettingsScreen(@Nullable Screen parent) {
        super(TITLE, 248, 219);
        this.parent = parent;
    }

    public VoiceChatSettingsScreen() {
        this(null);
    }

    @Override
    protected void init() {
        super.init();
        int y = this.guiTop + 20;
        this.addRenderableWidget((GuiEventListener)new VoiceSoundSlider(this.guiLeft + 10, y, this.xSize - 20, 20));
        boolean agc = SpeexManager.canUseAgc();
        MicAmplificationSlider micAmp = new MicAmplificationSlider(this.guiLeft + 10 + (agc ? 81 : 0), y += 21, this.xSize - 20 - (agc ? 80 : 0) - 1, 20);
        if (agc) {
            this.addRenderableWidget((GuiEventListener)new AgcButton(this.guiLeft + 10, y, 80, 20, active -> micAmp.setActive(active == false)));
        }
        this.addRenderableWidget((GuiEventListener)micAmp);
        this.addRenderableWidget((GuiEventListener)new DenoiserButton(this.guiLeft + 10, y += 21, this.xSize - 20, 20));
        this.voiceActivationSlider = new VoiceActivationSlider(this.guiLeft + 10, (y += 21) + 42, this.xSize - 20, 20);
        VadButton vadButton = new VadButton(this.guiLeft + 10, y + 21, this.xSize - 20, 20);
        this.micTestButton = new MicTestButton(this.guiLeft + 10, y, false, this.voiceActivationSlider);
        this.keybindButton = new KeybindButton(KeyEvents.KEY_PTT, this.guiLeft + 10, y + 21, this.xSize - 20, 20, PUSH_TO_TALK);
        this.addRenderableWidget((GuiEventListener)new MicActivationButton(this.guiLeft + 10 + 20 + 1, y, this.xSize - 20 - 20 - 1, 20, type -> {
            vadButton.visible = MicrophoneActivationType.VOICE.equals(type);
            this.keybindButton.visible = MicrophoneActivationType.PTT.equals(type);
            this.keybindButton.resetListening();
        }));
        this.addRenderableWidget((GuiEventListener)this.micTestButton);
        this.addRenderableWidget((GuiEventListener)vadButton);
        this.addRenderableWidget((GuiEventListener)this.voiceActivationSlider);
        this.addRenderableWidget((GuiEventListener)this.keybindButton);
        this.addRenderableWidget((GuiEventListener)new EnumButton<AudioType>(this.guiLeft + 10, y += 63, this.xSize - 20, 20, VoicechatClient.CLIENT_CONFIG.audioType){

            protected void renderContents(GuiGraphics guiGraphics, int i, int j, float f) {
                this.renderDefaultSprite(guiGraphics);
                this.renderDefaultLabel(guiGraphics.textRendererForWidget((AbstractWidget)this, GuiGraphics.HoveredTextEffects.NONE));
            }

            @Override
            protected Component getText(AudioType type) {
                return Component.translatable((String)"message.voicechat.audio_type", (Object[])new Object[]{type.getText()});
            }

            @Override
            protected void onUpdate(AudioType type) {
                ClientVoicechat client = ClientManager.getClient();
                if (client != null) {
                    VoiceChatSettingsScreen.this.micTestButton.stop();
                    client.reloadAudio();
                }
            }
        });
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)SELECT_MICROPHONE, button -> this.minecraft.setScreen((Screen)new SelectMicrophoneScreen(this))).bounds(this.guiLeft + 10, y += 21, (this.xSize - 20) / 2 - 1, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)SELECT_SPEAKER, button -> this.minecraft.setScreen((Screen)new SelectSpeakerScreen(this))).bounds(this.guiLeft + this.xSize / 2 + 1, y, (this.xSize - 20) / 2 - 1, 20).build());
        y += 21;
        if (!this.isIngame() && this.parent != null) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)BACK, button -> this.minecraft.setScreen(this.parent)).bounds(this.guiLeft + 10, y, this.xSize - 20, 20).build());
        }
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        if (this.keybindButton.mouseClicked(mouseButtonEvent, bl)) {
            return true;
        }
        return super.mouseClicked(mouseButtonEvent, bl);
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.keybindButton.keyPressed(keyEvent)) {
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public boolean keyReleased(KeyEvent keyEvent) {
        if (this.keybindButton.keyReleased(keyEvent)) {
            return true;
        }
        return super.keyReleased(keyEvent);
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (this.isIngame()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.guiLeft, this.guiTop, 0.0f, 0.0f, this.xSize, this.ySize, 256, 256);
        }
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int titleWidth = this.font.width((FormattedText)TITLE);
        guiGraphics.drawString(this.font, TITLE.getVisualOrderText(), this.guiLeft + (this.xSize - titleWidth) / 2, this.guiTop + 7, this.getFontColor(), false);
        Component sliderTooltip = this.voiceActivationSlider.getHoverText();
        if (this.voiceActivationSlider.isHovered() && sliderTooltip != null) {
            guiGraphics.setTooltipForNextFrame(this.font, sliderTooltip, mouseX, mouseY);
        } else if (this.keybindButton.isHovered()) {
            guiGraphics.setTooltipForNextFrame(this.font, ASSIGN_TOOLTIP, mouseX, mouseY);
        }
    }

    public boolean shouldCloseOnEsc() {
        if (this.keybindButton.isListening()) {
            return false;
        }
        return super.shouldCloseOnEsc();
    }
}

