/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.rendering;

import java.awt.Color;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.Identifier;
import org.jetbrains.annotations.NotNull;

public class RenderUtils {
    public static Color getColorFromHexString(@NotNull String hex) {
        try {
            hex = hex.replace("#", "");
            if (hex.length() == 6) {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
            }
            if (hex.length() == 8) {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16), Integer.valueOf(hex.substring(6, 8), 16));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @NotNull
    public static Identifier register(@NotNull String location, @NotNull AbstractTexture texture) {
        Objects.requireNonNull(location);
        Objects.requireNonNull(texture);
        Identifier loc = location.contains(":") ? Identifier.parse((String)location) : Identifier.fromNamespaceAndPath((String)"konkrete", (String)location);
        Minecraft.getInstance().getTextureManager().register(loc, texture);
        return loc;
    }
}

