/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easypiglins.items;

import de.maxhenkel.easypiglins.EasyPiglinsMod;
import de.maxhenkel.easypiglins.datacomponents.PiglinData;
import de.maxhenkel.easypiglins.items.ClientPiglinItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.Nullable;

public class PiglinItem
extends Item {
    public PiglinItem(Item.Properties properties) {
        super(properties.stacksTo(1).component(DataComponents.ITEM_NAME, (Object)Component.translatable((String)EntityType.PIGLIN.getDescriptionId())));
        DispenserBlock.registerBehavior((ItemLike)this, (source, stack) -> {
            Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
            BlockPos blockpos = source.pos().relative(direction);
            ServerLevel world = source.level();
            Piglin piglin = PiglinData.createPiglin(stack, (Level)world);
            piglin.snapTo((double)blockpos.getX() + 0.5, (double)blockpos.getY(), (double)blockpos.getZ() + 0.5, direction.toYRot(), 0.0f);
            world.addFreshEntity((Entity)piglin);
            stack.shrink(1);
            return stack;
        });
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (world.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.getItemInHand();
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockstate = world.getBlockState(blockpos);
        if (!blockstate.getCollisionShape((BlockGetter)world, blockpos).isEmpty()) {
            blockpos = blockpos.relative(direction);
        }
        Piglin piglin = PiglinData.createPiglin(itemstack, world);
        piglin.setPos((double)blockpos.getX() + 0.5, (double)blockpos.getY(), (double)blockpos.getZ() + 0.5);
        if (world.addFreshEntity((Entity)piglin)) {
            itemstack.shrink(1);
        }
        return InteractionResult.CONSUME;
    }

    public Component getName(ItemStack stack) {
        Component clientName;
        if (FMLEnvironment.getDist().isClient() && (clientName = ClientPiglinItemUtils.getClientName(stack)) != null) {
            return clientName;
        }
        return super.getName(stack);
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        super.inventoryTick(stack, level, entity, slot);
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!((Boolean)EasyPiglinsMod.SERVER_CONFIG.piglinInventorySounds.get()).booleanValue()) {
            return;
        }
        if (level.getGameTime() % 20L != 0L) {
            return;
        }
        if (level.random.nextInt(20) == 0) {
            player.connection.send((Packet)new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.PIGLIN_AMBIENT), SoundSource.HOSTILE, player.getX(), player.getY(), player.getZ(), 1.0f, 1.0f, player.getRandom().nextLong()));
        }
    }
}

