/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.group;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.util.tuple.Tuple2;
import journeymap.api.v2.common.event.common.WaypointGroupEvent;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.TextBox;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.dropdown.DropDownButton;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.ImageDropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerButton;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerScreen;
import journeymap.client.ui.component.popupscreenbutton.imageselect.ImageSelectButton;
import journeymap.client.ui.component.popupscreenbutton.imageselect.ImageSelectionScreen;
import journeymap.client.ui.waypointmanager.group.DeleteConfirmGroupPopup;
import journeymap.common.waypoint.WaypointGroupStore;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.Identifier;

public class EditGroupPopup
extends PopupButtonScreen<WaypointGroupEvent>
implements SelectableParent {
    private TextBox nameTextBox;
    private TextBox tagTextBox;
    protected static Integer defaultGroupColor = new Color(20, 20, 20).getRGB();
    private final WaypointGroup group;
    private boolean closeOnDelete = false;
    private Integer color;
    private Boolean colorOverride;
    private Boolean iconOverride;
    private boolean showOnLocatorBar = false;
    private boolean isNew = false;
    private boolean enabled = true;
    private List<DropDownItem> iconDropDownItems;
    private DropDownButton iconDropDown;
    private ImageSelectButton<ImageSelectionScreen.Response> imageSelectButton;
    private Identifier iconLocation;

    public EditGroupPopup(Component title, WaypointGroup group) {
        super(title);
        this.group = group;
        this.colorOverride = group.colorOverride();
        this.iconOverride = group.iconOverride();
        this.setOnClosed(g -> {});
    }

    public EditGroupPopup(Component title) {
        this(title, WaypointFactoryImpl.instance.createWaypointGroup(""));
        this.isNew = true;
    }

    protected void init() {
        boolean locked;
        this.nameTextBox = new TextBox(this.group.getName(), this.font, 120, 20);
        this.tagTextBox = new TextBox(this.group.getTag(), this.font, 50, 20);
        this.tagTextBox.setMaxLength(6);
        CheckBox colorOverride = new CheckBox(Constants.getString("jm.waypoint.edit_group.color_override"), this.group.colorOverride(), this::setColorOverride);
        colorOverride.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.edit_group.color_override.tooltip")));
        CheckBox iconOverride = new CheckBox(Constants.getString("jm.waypoint.edit_group.icon_override"), this.group.iconOverride(), this::setIconOverride);
        iconOverride.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.edit_group.icon_override.tooltip")));
        CheckBox showOnLocatorBar = new CheckBox(Constants.getString("jm.waypoint.edit_group.locator_bar"), this.group.isShowOnLocatorBar(), this::showOnLocatorBar);
        showOnLocatorBar.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.edit_group.locator_bar.tooltip")));
        this.iconDropDownItems = this.buildIconDropdownItems();
        this.layout.spacing(12).defaultCellSetting().alignHorizontallyCenter();
        this.layout.addChild((LayoutElement)new MultiLineTextWidget((Component)this.title.copy().withStyle(ChatFormatting.BOLD), this.font).setMaxWidth(150).setCentered(true));
        boolean bl = locked = this.group.isLocked() || WaypointGroupStore.DEFAULT.getGuid().equals(this.group.getGuid());
        if (locked) {
            this.tagTextBox.setEditable(false);
            this.nameTextBox.setEditable(false);
            StringWidget lockedText = (StringWidget)this.layout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.waypoint.edit_group.locked").copy().withStyle(ChatFormatting.RED), this.font));
            lockedText.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.edit_group.locked.tooltip")));
        } else {
            this.setInitialFocus((GuiEventListener)this.nameTextBox);
        }
        this.layout.addChild((LayoutElement)this.enabledCheckbox());
        LinearLayout colors = LinearLayout.horizontal();
        colors.spacing(6);
        Integer initGroupColor = this.group.getColor() == null ? defaultGroupColor : this.group.getColor();
        colors.addChild((LayoutElement)new ColorPickerButton(20, 20, () -> initGroupColor, this::setColor));
        colors.addChild((LayoutElement)colorOverride, LayoutSettings::alignVerticallyMiddle);
        if (JourneymapClient.getInstance().getWaypointProperties().displayOnLocatorBar.get().booleanValue()) {
            colors.addChild((LayoutElement)showOnLocatorBar, LayoutSettings::alignVerticallyMiddle);
        }
        LinearLayout iconLayout = LinearLayout.horizontal();
        iconLayout.spacing(6);
        this.imageSelectButton = new ImageSelectButton<ImageSelectionScreen.Response>(20, 20, 16, 16, this.iconLocation != null ? this.iconLocation : this.group.getIconIdentifier(), initGroupColor, (Component)Component.translatable((String)"jm.waypoint.icon.select"), () -> new ImageSelectionScreen((Component)Component.translatable((String)"jm.waypoint.icon.select"), this.iconLocation != null ? this.iconLocation : this.group.getIconIdentifier(), TextureCache.waypointIconMap.keySet().stream().toList(), initGroupColor), this::onIconUpdate);
        this.imageSelectButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.icon.select.tooltip")));
        this.iconDropDown = new DropDownButton("", this::onIconUpdate);
        this.iconDropDown.setItems(this.iconDropDownItems);
        this.iconDropDown.setDefaultStyle(false);
        this.iconDropDown.setDrawBackground(false);
        this.iconDropDown.setSelectedId(this.group.getIconIdentifier().toString().replace("ui/img", "textures/waypoint/icon"));
        this.iconDropDown.setRenderSolidBackground(true);
        if (TextureCache.waypointIconMap.size() > 4) {
            iconLayout.addChild(this.imageSelectButton, LayoutSettings::alignVerticallyMiddle);
        } else {
            iconLayout.addChild((LayoutElement)this.iconDropDown, LayoutSettings::alignVerticallyMiddle);
        }
        iconLayout.addChild((LayoutElement)iconOverride, LayoutSettings::alignVerticallyMiddle);
        LinearLayout bottomButtons = LinearLayout.horizontal();
        GridLayout locGridLayout = new GridLayout();
        locGridLayout.columnSpacing(6);
        locGridLayout.rowSpacing(4);
        bottomButtons.spacing(6);
        PopupButton deleteButton = (PopupButton)bottomButtons.addChild(new PopupButton<Tuple2>(this.font.width(Constants.getString("jm.common.delete")) + 10, 0, (Component)Component.translatable((String)"jm.common.delete"), () -> new DeleteConfirmGroupPopup(this.group), this::deleteGroup));
        deleteButton.visible = !this.group.getGuid().equals(WaypointGroupStore.DEFAULT.getGuid()) && !this.group.isLocked() && !this.isNew;
        bottomButtons.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.waypoint.save"), b -> this.save()).width(this.font.width((FormattedText)CommonComponents.GUI_CONTINUE) + 10).build());
        bottomButtons.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> super.onClose()).width(this.font.width((FormattedText)CommonComponents.GUI_CANCEL) + 10).build());
        locGridLayout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.waypoint.name").copy().withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), this.font), 0, 0);
        StringWidget tagLabel = (StringWidget)locGridLayout.addChild((LayoutElement)new StringWidget((Component)Component.translatable((String)"jm.waypoint.edit_group.tag").copy().withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), this.font), 0, 1);
        tagLabel.setTooltip(Tooltip.create((Component)Component.translatable((String)"jm.waypoint.edit_group.tag.tooltip")));
        locGridLayout.addChild((LayoutElement)this.nameTextBox, 1, 0);
        locGridLayout.addChild((LayoutElement)this.tagTextBox, 1, 1);
        this.layout.addChild((LayoutElement)locGridLayout);
        this.layout.addChild((LayoutElement)colors);
        if (!locked) {
            this.layout.addChild((LayoutElement)iconLayout);
        }
        this.layout.addChild((LayoutElement)bottomButtons);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    private void onIconUpdate(Button button) {
        this.iconLocation = Identifier.parse((String)this.iconDropDown.getSelected().getId().toString());
    }

    private void onIconUpdate(ImageSelectionScreen.Response response) {
        if (!response.cancelled()) {
            this.setColor(response.color());
            this.imageSelectButton.setLocation(response.identifier());
            this.imageSelectButton.setColor(response.color());
            this.iconLocation = response.identifier();
        }
    }

    private void deleteGroup(Tuple2<Boolean, Boolean> tuple) {
        EventBus.post(new WaypointGroupEvent(this.group, WaypointGroupEvent.Context.DELETED, ((Boolean)tuple.a()).booleanValue()));
        this.closeOnDelete = true;
        super.onClose();
    }

    private void setColorOverride(Button button) {
        this.colorOverride = ((CheckBox)button).getToggled();
    }

    private void setIconOverride(Button button) {
        this.iconOverride = ((CheckBox)button).getToggled();
    }

    private void showOnLocatorBar(Button button) {
        this.showOnLocatorBar = ((CheckBox)button).getToggled();
    }

    private void setColor(ColorPickerScreen.ColorPickerResponse colorPickerResponse) {
        if (!colorPickerResponse.canceled()) {
            this.setColor(colorPickerResponse.color());
        }
    }

    private void setColor(int color) {
        this.color = color;
        this.iconDropDownItems.forEach(item -> ((ImageDropDownItem)((Object)item)).setColor(color));
    }

    protected void renderPopupScreen(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderPopupScreen(graphics, mouseX, mouseY, partialTicks);
        if (this.minecraft.screen == this && this.closeOnDelete) {
            this.onClose();
        }
    }

    private CheckBox enabledCheckbox() {
        boolean enabled = this.group == null || this.group.isEnabled();
        return new CheckBox(Constants.getString("jm.common.enabled"), enabled, button -> this.setEnabled(((CheckBox)button).getToggled()));
    }

    private void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.key() == 257) {
            this.save();
            return true;
        }
        return super.keyPressed(event);
    }

    private void save() {
        String name = this.nameTextBox.getValue();
        if (!name.isEmpty()) {
            this.group.setName(name);
            this.group.setEnabled(this.enabled);
            this.group.setTag(this.tagTextBox.getValue());
            this.group.setShowOnLocatorBar(this.showOnLocatorBar);
            if (this.iconOverride != null) {
                this.group.setIconOverride(this.iconOverride.booleanValue());
                if (this.iconLocation != null && this.iconOverride.booleanValue()) {
                    this.group.setIconResourceLoctaion(this.iconLocation);
                }
            }
            if (this.colorOverride != null) {
                this.group.setColorOverride(this.colorOverride.booleanValue());
                if (this.color != null && this.colorOverride.booleanValue()) {
                    this.group.setColor(this.color);
                }
            }
            this.setResponseAndClose(EventBus.post(new WaypointGroupEvent(this.group, this.isNew ? WaypointGroupEvent.Context.CREATE : WaypointGroupEvent.Context.UPDATE)));
        }
    }

    private List<DropDownItem> buildIconDropdownItems() {
        Identifier loc2;
        ArrayList<DropDownItem> list = new ArrayList<DropDownItem>();
        if (!TextureCache.waypointIconMap.containsKey(this.group.getIconIdentifier()) && (loc2 = this.group.getIconIdentifier()) != null) {
            ImageDropDownItem icon = new ImageDropDownItem((SelectableParent)this, loc2, 16, 16, b -> {}, loc2.toString());
            icon.setColor(this.group.getIconColor());
            list.add(icon);
        }
        TextureCache.waypointIconMap.forEach((loc, tex) -> {
            ImageDropDownItem icon = new ImageDropDownItem((SelectableParent)this, (Identifier)loc, 16, 16, b -> {}, loc.toString());
            icon.setColor(this.group.getColor() == null || !this.group.colorOverride() ? -1 : this.group.getColor());
            list.add(icon);
        });
        return list;
    }

    @Override
    public void setSelected(DropDownItem button) {
        if (button instanceof ImageDropDownItem) {
            ImageDropDownItem imgButton = (ImageDropDownItem)button;
            this.iconDropDown.setSelected(imgButton);
        }
    }
}

