/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton.imageselect;

import java.util.function.Supplier;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import net.minecraft.client.gui.ActiveTextCollector;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;

public class ImageSelectButton<T>
extends PopupButton<T> {
    private Identifier location;
    private int color;
    private final int imageWidth;
    private final int imageHeight;

    public ImageSelectButton(int width, int height, int imageWidth, int imageHeight, Identifier location, Integer color, Component title, Supplier<PopupButtonScreen<T>> screen, PopupButtonScreen.OnClose<T> onClose) {
        super(width, height, title, screen, onClose);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.location = location;
        this.color = -1;
        if (color != null) {
            this.color = RGB.toInteger(RGB.floats(color, 255.0f));
        }
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setLocation(Identifier location) {
        this.location = location;
    }

    @Override
    public void renderContents(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderContents(graphics, mouseX, mouseY, partialTick);
        DrawUtil.drawTexture(graphics, this.location, this.color, 1.0f, this.getX() + (this.imageWidth >> 3), this.getY() + (this.imageHeight >> 3), this.imageWidth, this.imageHeight, 0.0, false, false);
    }

    public void renderScrollingStringOverContents(ActiveTextCollector activeTextCollector, Component component, int i) {
    }
}

