/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import javax.annotation.Nullable;
import journeymap.client.texture.gl.GlMaskedTexture;
import journeymap.common.Journeymap;
import net.minecraft.client.renderer.texture.AbstractTexture;

public class MaskedTexture
extends AbstractTexture {
    private NativeImage pixels;
    private String description;
    private GpuTexture depthTexture;
    private GpuTextureView depthView;

    public MaskedTexture(String description, NativeImage pixels) {
        this.pixels = pixels;
        this.description = description;
        this.depthTexture = GlMaskedTexture.createTexture(description, 8, TextureFormat.DEPTH32, pixels.getWidth(), pixels.getHeight(), 1, 1);
        this.texture = GlMaskedTexture.createTexture(description, 12, TextureFormat.RGBA8, pixels.getWidth(), pixels.getHeight(), 1, 1);
        this.depthView = RenderSystem.getDevice().createTextureView(this.depthTexture);
        this.textureView = RenderSystem.getDevice().createTextureView(this.texture);
    }

    public void upload() {
        if (this.pixels != null && this.texture != null) {
            RenderSystem.getDevice().createCommandEncoder().writeToTexture(this.depthTexture, this.pixels);
        } else {
            Journeymap.getLogger().warn("Trying to upload disposed texture {}", (Object)this.getTexture().getLabel());
        }
    }

    public GpuTexture getDepthTexture() {
        return this.depthTexture;
    }

    public GpuTextureView getDepthView() {
        return this.depthView;
    }

    @Nullable
    public NativeImage getPixels() {
        return this.pixels;
    }

    public void setPixels(NativeImage pixels) {
        if (this.pixels != null) {
            this.pixels.close();
        }
        this.pixels = pixels;
    }

    public void close() {
        if (this.pixels != null) {
            this.pixels.close();
            this.pixels = null;
        }
        super.close();
    }
}

