/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.RenderWrapper;
import journeymap.client.texture.ComparableNativeImage;
import journeymap.common.Journeymap;
import journeymap.common.accessors.NativeImageAccess;
import net.minecraft.client.renderer.texture.AbstractTexture;
import org.lwjgl.stb.STBImageResize;

public class ImageUtil {
    public static NativeImage getSizedImage(int width, int height, NativeImage from, boolean autoClose) {
        NativeImage scaledImage = new NativeImage(from.format(), width, height, false);
        STBImageResize.nstbir_resize_uint8_generic((long)from.pixels, (int)from.getWidth(), (int)from.getHeight(), (int)0, (long)scaledImage.pixels, (int)width, (int)height, (int)0, (int)from.format().components(), (int)-1, (int)0, (int)1, (int)1, (int)0, (long)0L);
        if (autoClose) {
            from.close();
        }
        return scaledImage;
    }

    public static NativeImage getScaledImage(float scale, NativeImage from, boolean autoClose) {
        int scaledWidth = (int)((float)from.getWidth() * scale);
        int scaledHeight = (int)((float)from.getHeight() * scale);
        NativeImage scaledImage = new NativeImage(from.format(), scaledWidth, scaledHeight, false);
        STBImageResize.nstbir_resize_uint8_generic((long)from.pixels, (int)from.getWidth(), (int)from.getHeight(), (int)0, (long)scaledImage.pixels, (int)scaledWidth, (int)scaledHeight, (int)0, (int)from.format().components(), (int)-1, (int)0, (int)1, (int)1, (int)0, (long)0L);
        if (autoClose) {
            from.close();
        }
        return scaledImage;
    }

    public static ComparableNativeImage getComparableSubImage(int x, int y, int width, int height, NativeImage from, boolean autoClose) {
        ComparableNativeImage to = new ComparableNativeImage(from.format(), width, height);
        return (ComparableNativeImage)ImageUtil.getSubImage(x, y, width, height, from, to, autoClose);
    }

    public static NativeImage getSubImage(int x, int y, int width, int height, NativeImage from, boolean autoClose) {
        NativeImage to = new NativeImage(width, height, false);
        return ImageUtil.getSubImage(x, y, width, height, from, to, autoClose);
    }

    public static NativeImage getSubImage(int x, int y, int width, int height, NativeImage from, NativeImage to, boolean autoClose) {
        if (from.pixels == 0L) {
            throw new IllegalStateException("Image is not allocated. " + String.valueOf(from));
        }
        if (to.format() != from.format()) {
            throw new UnsupportedOperationException("getSubImage only works for images of the same format.");
        }
        int i = from.format().components();
        STBImageResize.nstbir_resize_uint8_generic((long)(from.pixels + ((long)x + (long)y * (long)from.getWidth()) * (long)i), (int)width, (int)height, (int)(from.getWidth() * i), (long)to.pixels, (int)to.getWidth(), (int)to.getHeight(), (int)0, (int)from.format().components(), (int)-1, (int)0, (int)1, (int)1, (int)0, (long)0L);
        if (autoClose) {
            from.close();
        }
        return to;
    }

    public static NativeImage recolorImage(NativeImage image, int color) {
        NativeImage tintedImage = new NativeImage(image.getWidth(), image.getHeight(), false);
        tintedImage.copyFrom(image);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getWidth(); ++y) {
                int imgColor = image.getPixel(x, y);
                if (ImageUtil.getAlpha(imgColor) <= 1) continue;
                ((NativeImageAccess)tintedImage).blendPixel(x, y, RGB.toArgb(color, 0.75f));
            }
        }
        return tintedImage;
    }

    public static NativeImage getNewBlankImage(int width, int height) {
        NativeImage image = new NativeImage(width, height, false);
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                image.setPixel(x, y, RGB.toRgba(0, 0.0f));
            }
        }
        return image;
    }

    public static void closeSafely(NativeImage image) {
        if (image != null) {
            try {
                image.close();
            }
            catch (Throwable t) {
                Journeymap.getLogger().warn("Failed to clear and close image: ", t);
            }
        }
    }

    public static void closeSafely(AbstractTexture texture) {
        if (texture != null) {
            try {
                if (!RenderSystem.isOnRenderThread()) {
                    RenderWrapper.recordRenderQueue(() -> ((AbstractTexture)texture).close());
                } else {
                    texture.close();
                }
            }
            catch (Throwable t) {
                Journeymap.getLogger().warn("Failed to clear and close image: ", t);
            }
        }
    }

    public static int getAlpha(int color) {
        return color >> 24 & 0xFF;
    }
}

