/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.task.main;

import journeymap.client.JourneymapClient;
import journeymap.client.log.ChatLog;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.resources.Identifier;
import org.apache.logging.log4j.Logger;

public class MappingMonitorTask
implements IMainThreadTask {
    private static String NAME = "Tick." + MappingMonitorTask.class.getSimpleName();
    Logger logger = Journeymap.getLogger();
    private Identifier lastDimension = null;
    private boolean shouldReset = true;

    @Override
    public IMainThreadTask perform(Minecraft mc, JourneymapClient jm) {
        try {
            boolean isGamePaused;
            boolean isDead;
            boolean inMainMenu;
            Screen guiScreen = mc.screen;
            boolean bl = inMainMenu = guiScreen instanceof TitleScreen || guiScreen instanceof SelectWorldScreen || guiScreen instanceof JoinMultiplayerScreen;
            if (inMainMenu) {
                jm.setEnable();
            }
            if (!jm.isInitialized().booleanValue()) {
                return this;
            }
            boolean bl2 = isDead = mc.screen != null && mc.screen instanceof DeathScreen;
            if (mc.level == null) {
                if (jm.isMapping().booleanValue()) {
                    jm.stopMapping();
                }
                if (inMainMenu && jm.getCurrentWorldId() != null) {
                    this.logger.info("World ID has been reset.");
                    jm.setCurrentWorldId(null);
                }
                return this;
            }
            if (this.lastDimension == null || mc.player != null && mc.player.level() != null && !mc.player.level().dimension().identifier().equals((Object)this.lastDimension)) {
                this.lastDimension = mc.player.level().dimension().identifier();
                if (jm.isMapping().booleanValue()) {
                    jm.stopMapping();
                }
            } else if (!jm.isMapping().booleanValue() && !isDead) {
                if (JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                    jm.startMapping();
                    this.shouldReset = true;
                } else if (this.shouldReset) {
                    jm.reset();
                    this.shouldReset = false;
                }
            }
            boolean bl3 = isGamePaused = mc.screen != null && !(mc.screen instanceof Fullscreen);
            if (isGamePaused && !jm.isMapping().booleanValue()) {
                return this;
            }
            if (!isGamePaused) {
                ChatLog.showChatAnnouncements(mc);
            }
            if (!jm.isMapping().booleanValue()) {
                if (JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) {
                    jm.startMapping();
                    this.shouldReset = true;
                } else if (this.shouldReset) {
                    jm.reset();
                    this.shouldReset = false;
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in JourneyMap.performMainThreadTasks(): " + LogFormatter.toString(t));
        }
        return this;
    }

    @Override
    public String getName() {
        return NAME;
    }
}

