/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render;

import com.mojang.blaze3d.opengl.GlTexture;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import journeymap.client.render.Pipelines;
import journeymap.client.render.RegionTileShaders;
import journeymap.client.texture.RegionTexture;
import journeymap.common.mixin.client.RenderTypeInvoker;
import net.minecraft.client.renderer.rendertype.LayeringTransform;
import net.minecraft.client.renderer.rendertype.RenderSetup;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.Identifier;

public class JMRenderTypes {
    public static final Identifier WAYPOINT_DEFAULT_BEAM = Identifier.parse((String)"textures/entity/beacon_beam.png");
    static final Object2ObjectOpenHashMap<Identifier, RenderType> GRID_LINES_RENDER_TYPE_MAP = new Object2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<Int2ObjectOpenHashMap<RenderType>> REGION_TILE_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<RenderType> ICON_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<RenderType> ICON_CLAMP_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<RenderType> ICON_NOBLUR_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Int2ObjectOpenHashMap<RenderType> ICON_UNMASKED_RENDER_TYPE_MAP = new Int2ObjectOpenHashMap();
    static final Object2ObjectOpenHashMap<Identifier, RenderType> POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP = new Object2ObjectOpenHashMap();
    public static final RenderType MINIMAP_RECTANGLE_MASK_RENDER_TYPE = JMRenderTypes.createRenderType("minimap_rectangle_mask", RenderSetup.builder((RenderPipeline)Pipelines.MINIMAP_RECTANGLE_MASK_RENDER_PIPELINE).setLayeringTransform(LayeringTransform.NO_LAYERING).createRenderSetup());
    public static final RenderType RECTANGLE_RENDER_TYPE = JMRenderTypes.createRenderType("rectangle", RenderSetup.builder((RenderPipeline)Pipelines.RECTANGLE_RENDER_PIPELINE).setLayeringTransform(LayeringTransform.NO_LAYERING).createRenderSetup());
    public static final RenderType GRID_LINES_RENDER_TYPE = JMRenderTypes.createRenderType("grid_lines", RenderSetup.builder((RenderPipeline)Pipelines.GRID_LINES_RENDER_PIPELINE).setLayeringTransform(LayeringTransform.NO_LAYERING).sortOnUpload().createRenderSetup());
    public static final RenderType POLYGON_WITHOUT_TEXTURE_RENDER_TYPE = JMRenderTypes.createRenderType("polygon", RenderSetup.builder((RenderPipeline)Pipelines.POLYGON_POS_PIPELINE).setLayeringTransform(LayeringTransform.NO_LAYERING).createRenderSetup());
    public static final RenderType POLYGON_STROKE_RENDER_TYPE = JMRenderTypes.createRenderType("polygon_stroke", RenderSetup.builder((RenderPipeline)Pipelines.POLYGON_STROKE_PIPELINE).setLayeringTransform(LayeringTransform.NO_LAYERING).createRenderSetup());

    public static void registerMapShader(String key, RenderPipeline shader) {
        REGION_TILE_RENDER_TYPE_MAP.clear();
    }

    public static void registerPosTexColorShader() {
        POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.clear();
        ICON_UNMASKED_RENDER_TYPE_MAP.clear();
        ICON_NOBLUR_RENDER_TYPE_MAP.clear();
        ICON_RENDER_TYPE_MAP.clear();
        ICON_CLAMP_RENDER_TYPE_MAP.clear();
        REGION_TILE_RENDER_TYPE_MAP.clear();
        GRID_LINES_RENDER_TYPE_MAP.clear();
    }

    public static void clearRegionRenderTypes(int id) {
        if (id != -1) {
            Int2ObjectOpenHashMap map = (Int2ObjectOpenHashMap)REGION_TILE_RENDER_TYPE_MAP.get(id);
            if (map != null) {
                map.clear();
            }
            REGION_TILE_RENDER_TYPE_MAP.remove(id);
        }
    }

    public static RenderType getRegionTile(RegionTexture texture, int shaderIndex) {
        RenderType type;
        int id = ((GlTexture)texture.getTexture()).glId();
        Int2ObjectOpenHashMap map = (Int2ObjectOpenHashMap)REGION_TILE_RENDER_TYPE_MAP.get(id);
        if (map == null) {
            map = new Int2ObjectOpenHashMap();
            REGION_TILE_RENDER_TYPE_MAP.put(id, (Object)map);
        }
        if ((type = (RenderType)map.get(shaderIndex)) == null) {
            String shader = RegionTileShaders.from(shaderIndex);
            RenderPipeline shaderState = Pipelines.REGION_SHADERS_MAP.get((Object)shader) == null ? Pipelines.REGION_DEFAULT_RENDER_PIPELINE : (RenderPipeline)Pipelines.REGION_SHADERS_MAP.get((Object)shader);
            type = JMRenderTypes.createRenderType("region_tile" + id, RenderSetup.builder((RenderPipeline)shaderState).withTexture("Sampler0", texture.getTextureLocation()).setLayeringTransform(LayeringTransform.NO_LAYERING).createRenderSetup());
            map.put(id, (Object)type);
        }
        return type;
    }

    public static RenderType getCircleMask(Identifier identifier) {
        return JMRenderTypes.createRenderType("circle_mask", RenderSetup.builder((RenderPipeline)Pipelines.CIRCLE_MASK_PIPELINE).withTexture("Sampler0", identifier, () -> RenderSystem.getSamplerCache().getClampToEdge(FilterMode.NEAREST)).setLayeringTransform(LayeringTransform.NO_LAYERING).createRenderSetup());
    }

    public static RenderType getPolygonWithTexture(AbstractTexture texture, Identifier identifier) {
        int id = ((GlTexture)texture.getTexture()).glId();
        RenderType type = (RenderType)POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.get((Object)identifier);
        if (type == null) {
            type = JMRenderTypes.createRenderType("polygon" + identifier.toDebugFileName(), RenderSetup.builder((RenderPipeline)Pipelines.POLYGON_WITH_TEXTURE_RENDER_PIPELINE).withTexture("Sampler0", identifier).setLayeringTransform(LayeringTransform.NO_LAYERING).createRenderSetup());
            POLYGON_WITH_TEXTURE_RENDER_TYPE_MAP.put((Object)identifier, (Object)type);
        }
        return type;
    }

    public static RenderType getGridLines(Identifier identifier) {
        RenderType type = (RenderType)GRID_LINES_RENDER_TYPE_MAP.get((Object)identifier);
        if (type == null) {
            type = JMRenderTypes.createRenderType("grid_lines_" + identifier.toDebugFileName(), RenderSetup.builder((RenderPipeline)Pipelines.GRID_LINES_RENDER_TYPE_PIPELINE).withTexture("Sampler0", identifier).setLayeringTransform(LayeringTransform.NO_LAYERING).sortOnUpload().createRenderSetup());
            GRID_LINES_RENDER_TYPE_MAP.put((Object)identifier, (Object)type);
        }
        return type;
    }

    public static RenderType createRenderType(String name, RenderSetup setup) {
        return RenderTypeInvoker.invokeCreate(name, setup);
    }
}

