/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model.chunk;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import journeymap.client.JourneymapClient;
import journeymap.client.model.block.BlockDataArrays;
import journeymap.client.model.block.BlockFlag;
import journeymap.client.model.block.BlockMD;
import journeymap.client.model.map.MapType;
import journeymap.client.world.JmBlockAccess;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.EmptyLevelChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;

public class ChunkMD {
    public static final String PROP_IS_SLIME_CHUNK = "isSlimeChunk";
    public static final String PROP_LOADED = "loaded";
    public static final String PROP_LAST_RENDERED = "lastRendered";
    protected final WeakReference<LevelChunk> chunkReference;
    private final ChunkPos coord;
    private final HashMap<String, Serializable> properties = new HashMap();
    private BlockDataArrays blockDataArrays = new BlockDataArrays();
    private final Random random;
    protected LevelChunk retainedChunk;
    private DataLayer lights;

    public ChunkMD(LevelChunk chunk) {
        this(chunk, false);
    }

    public ChunkMD(LevelChunk chunk, boolean forceRetain, DataLayer lights) {
        this(chunk, forceRetain);
        this.lights = lights;
    }

    public ChunkMD(LevelChunk chunk, boolean forceRetain) {
        if (chunk == null) {
            throw new IllegalArgumentException("Chunk can't be null");
        }
        this.random = new Random();
        this.coord = new ChunkPos(chunk.getPos().x, chunk.getPos().z);
        this.setProperty(PROP_LOADED, Long.valueOf(System.currentTimeMillis()));
        this.properties.put(PROP_IS_SLIME_CHUNK, Boolean.valueOf(ChunkMD.isSlimeChunk(chunk)));
        this.chunkReference = new WeakReference<LevelChunk>(chunk);
        if (forceRetain) {
            this.retainedChunk = chunk;
        }
    }

    public BlockState getBlockState(int localX, int y, int localZ) {
        if (localX < 0 || localX > 15 || localZ < 0 || localZ > 15) {
            Journeymap.getLogger().warn("Expected local coords, got global coords");
        }
        return this.getBlockState(new BlockPos(this.toWorldX(localX), y, this.toWorldZ(localZ)));
    }

    public BlockState getChunkBlockState(BlockPos blockPos) {
        return this.getChunk().getBlockState(blockPos);
    }

    public BlockState getBlockState(BlockPos blockPos) {
        return JmBlockAccess.INSTANCE.getBlockState(blockPos);
    }

    public BlockMD getBlockMD(BlockPos blockPos) {
        return BlockMD.getBlockMD(this, blockPos);
    }

    @Nullable
    public Holder<Biome> getBiomeHolder(BlockPos pos) {
        return this.getChunk().getNoiseBiome(pos.getX() >> 2, pos.getY() >> 2, pos.getZ() >> 2);
    }

    @Nullable
    public Biome getBiome(BlockPos pos) {
        Holder<Biome> holder = this.getBiomeHolder(pos);
        return holder != null ? (Biome)holder.value() : null;
    }

    public ResourceKey<Biome> getBiomeKey(BlockPos pos) {
        Holder<Biome> holder = this.getBiomeHolder(pos);
        if (holder != null) {
            Optional key = holder.unwrapKey();
            return key.orElse(Biomes.PLAINS);
        }
        return Biomes.PLAINS;
    }

    public int getSavedLightValue(int localX, int y, int localZ) {
        if (this.lights != null) {
            try {
                int localY = SectionPos.sectionRelative((int)y);
                return this.lights.get(localX, localY, localZ);
            }
            catch (Exception localY) {
                // empty catch block
            }
        }
        try {
            return this.getChunk().getLevel().getLightEngine().getLayerListener(LightLayer.BLOCK).getLightValue(this.getBlockPos(localX, y, localZ));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 1;
        }
    }

    public BlockMD getBlockMD(int localX, int y, int localZ) {
        return BlockMD.getBlockMD(this, this.getBlockPos(localX, y, localZ));
    }

    public int ceiling(int localX, int localZ) {
        int y = this.getPrecipitationHeight(this.getBlockPos(localX, 0, localZ));
        BlockPos blockPos = null;
        try {
            while (y >= this.getMinY()) {
                blockPos = this.getBlockPos(localX, y, localZ);
                BlockMD blockMD = this.getBlockMD(blockPos);
                if (blockMD == null) {
                    --y;
                    continue;
                }
                if (blockMD.isIgnore() || blockMD.hasFlag(BlockFlag.OpenToSky)) {
                    --y;
                    continue;
                }
                if (this.canBlockSeeTheSky(localX, y, localZ)) {
                    --y;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().warn(String.valueOf(e) + " at " + String.valueOf(blockPos), (Throwable)e);
        }
        return Math.max(this.getMinY(), y);
    }

    public boolean hasChunk() {
        LevelChunk chunk = (LevelChunk)this.chunkReference.get();
        boolean result = chunk != null && !(chunk instanceof EmptyLevelChunk);
        return result;
    }

    public int getHeight(BlockPos blockPos) {
        return this.getPrecipitationHeight(blockPos);
    }

    public int getPrecipitationHeight(int localX, int localZ) {
        return this.getPrecipitationHeight(this.getBlockPos(localX, 0, localZ));
    }

    public int getPrecipitationHeight(BlockPos blockPos) {
        if (!JourneymapClient.getInstance().getCoreProperties().ignoreHeightmaps.get().booleanValue()) {
            return this.getChunk().getHeight(Heightmap.Types.WORLD_SURFACE, blockPos.getX(), blockPos.getZ());
        }
        return this.getChunk().getMaxY();
    }

    public int getLightOpacity(BlockMD blockMD, int localX, int y, int localZ) {
        return blockMD.getBlockState().getLightBlock();
    }

    public Serializable getProperty(String name) {
        return this.properties.get(name);
    }

    public Serializable getProperty(String name, Serializable defaultValue) {
        Serializable currentValue = this.getProperty(name);
        if (currentValue == null) {
            this.setProperty(name, defaultValue);
            currentValue = defaultValue;
        }
        return currentValue;
    }

    public Serializable setProperty(String name, Serializable value) {
        return this.properties.put(name, value);
    }

    public int hashCode() {
        return this.getCoord().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkMD other = (ChunkMD)obj;
        return this.getCoord().equals((Object)other.getCoord());
    }

    public LevelChunk getChunk() {
        LevelChunk chunk = (LevelChunk)this.chunkReference.get();
        if (chunk == null) {
            throw new ChunkMissingException(this.getCoord());
        }
        return chunk;
    }

    public ClientLevel getWorld() {
        Minecraft mc = Minecraft.getInstance();
        try {
            return mc.player == null ? mc.level : (ClientLevel)mc.player.level();
        }
        catch (Throwable t) {
            return mc.level;
        }
    }

    public int getWorldActualHeight() {
        return this.getWorld().dimensionType().logicalHeight() + 1;
    }

    public Boolean hasNoSky() {
        return this.getWorld().dimensionType().skybox() == DimensionType.Skybox.NONE;
    }

    public boolean canBlockSeeTheSky(int localX, int y, int localZ) {
        int i = localX & 0xF;
        int k = localZ & 0xF;
        if (this.lights != null) {
            return this.getSavedLightValue(localX, y, localZ) > 0;
        }
        return this.getChunk().getLevel().canSeeSky(this.getBlockPos(localX, y, localZ));
    }

    public ChunkPos getCoord() {
        return this.coord;
    }

    public static boolean isSlimeChunk(LevelChunk chunk) {
        if (chunk.getLevel() instanceof ServerLevel) {
            return WorldgenRandom.seedSlimeChunk((int)chunk.getPos().x, (int)chunk.getPos().z, (long)((ServerLevel)chunk.getLevel()).getSeed(), (long)987234911L).nextInt(10) == 0;
        }
        return false;
    }

    public long getLoaded() {
        return (Long)this.getProperty(PROP_LOADED, Long.valueOf(0L));
    }

    public void resetRenderTimes() {
        this.getRenderTimes().clear();
    }

    public void resetRenderTime(MapType mapType) {
        this.getRenderTimes().put(mapType, 0L);
    }

    public void resetBlockData(MapType mapType) {
        this.getBlockData().get(mapType).clear();
    }

    protected HashMap<MapType, Long> getRenderTimes() {
        HashMap obj = this.properties.get(PROP_LAST_RENDERED);
        if (!(obj instanceof HashMap)) {
            obj = new HashMap();
            this.properties.put(PROP_LAST_RENDERED, obj);
        }
        return obj;
    }

    public long getLastRendered(MapType mapType) {
        return this.getRenderTimes().getOrDefault(mapType, 0L);
    }

    public long setRendered(MapType mapType) {
        long now = System.currentTimeMillis();
        this.getRenderTimes().put(mapType, now);
        return now;
    }

    public BlockPos getBlockPos(int localX, int y, int localZ) {
        return new BlockPos(this.toWorldX(localX), y, this.toWorldZ(localZ));
    }

    public int toWorldX(int localX) {
        return (this.coord.x << 4) + localX;
    }

    public int toWorldZ(int localZ) {
        return (this.coord.z << 4) + localZ;
    }

    public BlockDataArrays getBlockData() {
        return this.blockDataArrays;
    }

    public BlockDataArrays.DataArray<Integer> getBlockDataInts(MapType mapType) {
        return this.blockDataArrays.get(mapType).ints();
    }

    public BlockDataArrays.DataArray<Float> getBlockDataFloats(MapType mapType) {
        return this.blockDataArrays.get(mapType).floats();
    }

    public BlockDataArrays.DataArray<Boolean> getBlockDataBooleans(MapType mapType) {
        return this.blockDataArrays.get(mapType).booleans();
    }

    public String toString() {
        return "ChunkMD{coord=" + String.valueOf(this.coord) + ", properties=" + String.valueOf(this.properties) + "}";
    }

    public ResourceKey<Level> getDimension() {
        return this.getWorld().dimension();
    }

    public void stopChunkRetention() {
        this.retainedChunk = null;
    }

    public boolean hasRetainedChunk() {
        return this.retainedChunk != null;
    }

    public Integer getMinY() {
        return this.getWorld().getMinY();
    }

    public boolean fromNbt() {
        return false;
    }

    public long getLongCoord() {
        return this.coord.toLong();
    }

    public static class ChunkMissingException
    extends RuntimeException {
        ChunkMissingException(ChunkPos coord) {
            super("Chunk missing: " + String.valueOf(coord));
        }
    }
}

