/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.common.waypoint.WaypointFactoryImpl;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.event.PopupMenuEvent;
import journeymap.api.v2.client.fullscreen.IFullscreen;
import journeymap.api.v2.client.fullscreen.ModPopupMenu;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.model.TextProperties;
import journeymap.api.v2.common.event.FullscreenEventRegistry;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.command.CmdTeleportWaypoint;
import journeymap.client.data.DataCache;
import journeymap.client.io.FileHandler;
import journeymap.client.model.chunk.ChunkMD;
import journeymap.client.model.chunk.NBTChunkMD;
import journeymap.client.model.map.MapType;
import journeymap.client.model.region.RegionCoord;
import journeymap.client.task.main.DeleteMapTask;
import journeymap.client.task.multi.BaseMapTask;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.nbt.RegionData;
import journeymap.common.nbt.RegionDataStorageHandler;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;

public class PopupMenuEventHandler {
    public static PopupMenuEventHandler INSTANCE;

    private PopupMenuEventHandler() {
        FullscreenEventRegistry.FULLSCREEN_POPUP_MENU_EVENT.subscribe("journeymap", this::onFullscreenPopupMenu);
        FullscreenEventRegistry.WAYPOINT_POPUP_MENU_EVENT.subscribe("journeymap", this::onWaypointPopupMenu);
    }

    public static PopupMenuEventHandler init() {
        if (INSTANCE == null) {
            INSTANCE = new PopupMenuEventHandler();
        }
        return INSTANCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void onFullscreenPopupMenu(PopupMenuEvent.FullscreenPopupMenuEvent event) {
        if (!JourneymapClient.getInstance().enabled() || event.isCancelled()) return;
        try {
            if (CmdTeleportWaypoint.isPermitted(Minecraft.getInstance()) && JourneymapClient.getInstance().getStateHandler().isAllowRightClickTeleport()) {
                event.getPopupMenu().addMenuItem(Constants.getString("jm.waypoint.teleport"), this.doTeleport(event.getFullscreen()));
            }
            if (JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed()) {
                event.getPopupMenu().createSubItemList(Constants.getString("jm.waypoint.waypoints")).addMenuItem(Constants.getString("key.journeymap.create_waypoint"), this.createWaypoint(event.getFullscreen(), false)).addMenuItem(Constants.getString("jm.waypoint.create_temp_waypoint"), this.createWaypoint(event.getFullscreen(), true)).addMenuItem(Constants.getString("jm.waypoint.show_all"), b -> WaypointStore.renderWaypoints(true)).addMenuItem(Constants.getString("jm.waypoint.hide_all"), b -> WaypointStore.renderWaypoints(false));
            }
            if (!JourneymapClient.getInstance().getWaypointProperties().disableShare.get().booleanValue()) {
                event.getPopupMenu().addMenuItem(Constants.getString("key.journeymap.fullscreen.menu.chat_position"), this.chatAtPos(event.getFullscreen()));
            }
            ModPopupMenu advanced = event.getPopupMenu().createSubItemList(Constants.getString("jm.fullscreen.menu.advanced")).addMenuItem(Constants.getString("jm.fullscreen.menu.delete_region"), blockPos -> this.deleteRegion(blockPos, (Fullscreen)event.getFullscreen()));
            if (Minecraft.getInstance().hasSingleplayerServer() && !JourneymapClient.getInstance().getCoreProperties().mappingEnabled.get().booleanValue()) return;
        }
        catch (Exception e) {
            Journeymap.getLogger().error("Error handling PopupMenuEvent.FullscreenPopupMenuEvent", (Throwable)e);
        }
    }

    public void onWaypointPopupMenu(PopupMenuEvent.WaypointPopupMenuEvent event) {
        if (JourneymapClient.getInstance().enabled() && !event.isCancelled()) {
            try {
                Collection<ClientWaypointImpl> waypoints;
                ClientWaypointImpl waypoint;
                if (JourneymapClient.getInstance().getStateHandler().isWaypointsAllowed() && (waypoint = (ClientWaypointImpl)(waypoints = WaypointStore.getInstance().getAll()).stream().filter(wp -> event.getWaypoint().getId().equals(wp.getId())).findAny().orElse(null)) != null) {
                    if (CmdTeleportWaypoint.isPermitted(Minecraft.getInstance()) && CmdTeleportWaypoint.isPermitted(Minecraft.getInstance())) {
                        event.getPopupMenu().addMenuItem(Constants.getString("jm.waypoint.teleport"), blockPos -> new CmdTeleportWaypoint(waypoint).run());
                    }
                    event.getPopupMenu().addMenuItem(Constants.getString("jm.waypoint.edit"), blockPos -> UIManager.INSTANCE.openWaypointEditor(waypoint, false));
                    event.getPopupMenu().addMenuItem(Constants.getString("jm.waypoint.disable"), blockPos -> {
                        waypoint.setEnabled(false);
                        WaypointStore.getInstance().save(waypoint, false);
                    });
                    event.getPopupMenu().addMenuItem(Constants.getString("jm.waypoint.remove"), blockPos -> WaypointStore.getInstance().remove(waypoint, true));
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error handling PopupMenuEvent.FullscreenPopupMenuEvent", (Throwable)e);
            }
        }
    }

    private ModPopupMenu.Action chatAtPos(IFullscreen fullscreen) {
        return blockPos -> {
            ClientWaypointImpl waypoint = WaypointFactoryImpl.at(blockPos, false, fullscreen.getMinecraft().player.level().dimension().identifier().toString());
            ((Fullscreen)fullscreen).chatOpenedFromEvent = true;
            ((Fullscreen)fullscreen).openChat(waypoint.toChatString());
        };
    }

    private ModPopupMenu.Action createWaypoint(IFullscreen fullscreen, boolean temp) {
        return blockPos -> {
            int y = blockPos.getY();
            RegionData regionData = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(blockPos, ((Fullscreen)fullscreen).getMapType());
            if (regionData != null) {
                regionData.getTopY(blockPos);
            }
            BlockPos pos = new BlockPos(blockPos.getX(), y + 1, blockPos.getZ());
            ClientWaypointImpl waypoint = WaypointFactoryImpl.at(pos, false, fullscreen.getMinecraft().player.level().dimension().identifier().toString());
            if (temp) {
                waypoint.setOrigin("temp");
                if (JourneymapClient.getInstance().getStateHandler().isHideCoordinates()) {
                    waypoint.setName(Constants.getString("jm.common.unknown_location"));
                } else {
                    waypoint.setName(waypoint.getName());
                }
                ClientAPI.INSTANCE.addWaypoint("journeymap", waypoint);
                WaypointGroupStore.getInstance().get(WaypointGroupStore.TEMP.getGuid()).addWaypoint(waypoint);
            } else {
                UIManager.INSTANCE.openWaypointEditor(waypoint, false);
            }
        };
    }

    private ModPopupMenu.Action doTeleport(IFullscreen fullscreen) {
        return blockPos -> {
            int y = blockPos.getY();
            RegionData regionData = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(blockPos, ((Fullscreen)fullscreen).getMapType());
            if (regionData != null) {
                y = regionData.getTopY(blockPos);
            }
            BlockPos pos = new BlockPos(blockPos.getX(), y + 1, blockPos.getZ());
            CmdTeleportWaypoint.teleport(pos, (ResourceKey<Level>)Minecraft.getInstance().level.dimension(), null);
        };
    }

    private void deleteRegion(BlockPos blockPos, Fullscreen fullscreen) {
        try {
            MapType mapType = fullscreen.getMapType();
            ChunkPos pos = new ChunkPos(blockPos);
            File jmWorldDir = FileHandler.getJMWorldDir(Minecraft.getInstance());
            RegionCoord rCoord = RegionCoord.fromChunkPos(jmWorldDir, mapType, pos.x, pos.z);
            DeleteMapTask.queue(rCoord, mapType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ModPopupMenu.Action doRender(Fullscreen fullscreen) {
        return blockPos -> this.renderChunk(blockPos, fullscreen);
    }

    private void saveChunk(BlockPos pos) {
        try {
            Minecraft mc = Minecraft.getInstance();
            Path path = new File(FileHandler.getWorldSaveDir(mc), "region").toPath();
            RegionStorageInfo storage = new RegionStorageInfo(path.toString(), mc.level.dimension(), "chunk");
            SimpleRegionStorage loader = new SimpleRegionStorage(storage, path, DataFixers.getDataFixer(), true, DataFixTypes.LEVEL);
            CompletableFuture chunkFuture = loader.read(new ChunkPos(pos));
            File jmWorldDir = FileHandler.getJMWorldDir(mc);
            chunkFuture.whenCompleteAsync((chunkOptional, throwable) -> {
                if (chunkOptional.isPresent()) {
                    try {
                        NbtIo.writeCompressed((CompoundTag)((CompoundTag)chunkOptional.get()), (Path)new File(String.valueOf(jmWorldDir) + "/" + String.valueOf(new ChunkPos(pos)) + ".chunk.dat").toPath());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void renderChunk(BlockPos blockPos, Fullscreen fullscreen) {
        MapType mapType = fullscreen.getMapType();
        CompoundTag chunk = RegionDataStorageHandler.getInstance().getRegionDataAsyncNoCache(blockPos, mapType).getChunkNbt(new ChunkPos(blockPos));
        ChunkPos chunkPos = new ChunkPos(((Long)chunk.getLong("pos").get()).longValue());
        File jmWorldDir = FileHandler.getJMWorldDir(Minecraft.getInstance());
        RegionCoord rCoord = RegionCoord.fromChunkPos(jmWorldDir, mapType, chunkPos.x, chunkPos.z);
        RegionDataStorageHandler.Key key = new RegionDataStorageHandler.Key(rCoord, mapType);
        RegionData regionData = RegionDataStorageHandler.getInstance().getRegionData(key);
        try {
            NbtIo.writeCompressed((CompoundTag)chunk, (Path)new File(String.valueOf(jmWorldDir) + "/" + mapType.name() + ".chunk.dat").toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        NBTChunkMD chunkMd = new NBTChunkMD(new LevelChunk((Level)Minecraft.getInstance().level, chunkPos), chunkPos, chunk, mapType);
        ChunkMD md = DataCache.INSTANCE.getChunkMD(chunkPos.toLong());
        JourneymapClient.getInstance().getChunkRenderController().renderChunk(rCoord, fullscreen.getMapType(), chunkMd, regionData);
    }

    private void renderRegion(BlockPos blockPos, Fullscreen fullscreen) {
        try {
            JourneymapClient.getInstance().queueOneOff(() -> {
                ChunkPos pos = new ChunkPos(blockPos);
                MapType mapType = fullscreen.getMapType();
                File jmWorldDir = FileHandler.getJMWorldDir(Minecraft.getInstance());
                RegionCoord rCoord = RegionCoord.fromChunkPos(jmWorldDir, mapType, pos.x, pos.z);
                MapRegionTask.active = true;
                BaseMapTask task = MapRegionTask.create(JourneymapClient.getInstance().getChunkRenderController(), rCoord, mapType, Minecraft.getInstance());
                try {
                    task.performTask(Minecraft.getInstance(), JourneymapClient.getInstance(), jmWorldDir, false);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                JourneymapClient.getInstance().getMultithreadTaskController().getManager(MapRegionTask.Manager.class).disableTask(Minecraft.getInstance());
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected PolygonOverlay createOverlay(RegionCoord rCoord) {
        String displayId = "AutoMap" + String.valueOf(rCoord);
        String groupName = "AutoMap";
        String label = String.format("%s\nRegion [%s,%s]", "Remapping Region", rCoord.regionX, rCoord.regionZ);
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(2.0f).setStrokeColor(255).setStrokeOpacity(0.7f).setFillColor(65280).setFillOpacity(0.2f);
        TextProperties textProps = new TextProperties().setBackgroundColor(34).setBackgroundOpacity(0.5f).setColor(65280).setOpacity(1.0f).setFontShadow(true);
        int x = rCoord.getMinChunkX() << 4;
        int y = 70;
        int z = rCoord.getMinChunkZ() << 4;
        int maxX = (rCoord.getMaxChunkX() << 4) + 15;
        int maxZ = (rCoord.getMaxChunkZ() << 4) + 15;
        BlockPos sw = new BlockPos(x, y, maxZ);
        BlockPos se = new BlockPos(maxX, y, maxZ);
        BlockPos ne = new BlockPos(maxX, y, z);
        BlockPos nw = new BlockPos(x, y, z);
        MapPolygon polygon = new MapPolygon(new BlockPos[]{sw, se, ne, nw});
        PolygonOverlay regionOverlay = new PolygonOverlay("journeymap", rCoord.dimension, shapeProps, polygon);
        regionOverlay.setOverlayGroupName(groupName).setLabel(label).setTextProperties(textProps).setActiveUIs(new Context.UI[]{Context.UI.Fullscreen, Context.UI.Webmap}).setActiveMapTypes(Context.MapType.all());
        return regionOverlay;
    }
}

