/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SyncPacket(boolean canTeleport, List<Identifier> allowedStructureKeys, ListMultimap<Identifier, Identifier> dimensionKeysForAllowedStructureKeys, Map<Identifier, Identifier> structureKeysToTypeKeys, ListMultimap<Identifier, Identifier> typeKeysToStructureKeys) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncPacket> TYPE = new CustomPacketPayload.Type(Identifier.fromNamespaceAndPath((String)"explorerscompass", (String)"sync"));
    public static final StreamCodec<FriendlyByteBuf, SyncPacket> CODEC = StreamCodec.ofMember(SyncPacket::write, SyncPacket::read);

    public static SyncPacket read(FriendlyByteBuf buf) {
        boolean canTeleport = buf.readBoolean();
        ArrayList<Identifier> allowedStructureKeys = new ArrayList<Identifier>();
        ArrayListMultimap dimensionKeysForAllowedStructureKeys = ArrayListMultimap.create();
        HashMap<Identifier, Identifier> structureKeysToTypeKeys = new HashMap<Identifier, Identifier>();
        ArrayListMultimap typeKeysToStructureKeys = ArrayListMultimap.create();
        int numStructures = buf.readInt();
        for (int i = 0; i < numStructures; ++i) {
            Identifier structureKey = buf.readIdentifier();
            int numDimensions = buf.readInt();
            ArrayList<Identifier> dimensions = new ArrayList<Identifier>();
            for (int j = 0; j < numDimensions; ++j) {
                dimensions.add(buf.readIdentifier());
            }
            Identifier typeKey = buf.readIdentifier();
            if (structureKey == null) continue;
            allowedStructureKeys.add(structureKey);
            dimensionKeysForAllowedStructureKeys.putAll((Object)structureKey, dimensions);
            structureKeysToTypeKeys.put(structureKey, typeKey);
        }
        int numTypes = buf.readInt();
        for (int i = 0; i < numTypes; ++i) {
            Identifier typeKey = buf.readIdentifier();
            int numStructuresToAdd = buf.readInt();
            for (int j = 0; j < numStructuresToAdd; ++j) {
                Identifier structureKey = buf.readIdentifier();
                typeKeysToStructureKeys.put((Object)typeKey, (Object)structureKey);
            }
        }
        return new SyncPacket(canTeleport, allowedStructureKeys, (ListMultimap<Identifier, Identifier>)dimensionKeysForAllowedStructureKeys, structureKeysToTypeKeys, (ListMultimap<Identifier, Identifier>)typeKeysToStructureKeys);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.canTeleport);
        buf.writeInt(this.allowedStructureKeys.size());
        for (Identifier structureKey : this.allowedStructureKeys) {
            buf.writeIdentifier(structureKey);
            List dimensions = this.dimensionKeysForAllowedStructureKeys.get((Object)structureKey);
            buf.writeInt(dimensions.size());
            for (Identifier dimensionKey : dimensions) {
                buf.writeIdentifier(dimensionKey);
            }
            Identifier typeKey = this.structureKeysToTypeKeys.get(structureKey);
            buf.writeIdentifier(typeKey);
        }
        buf.writeInt(this.typeKeysToStructureKeys.keySet().size());
        for (Identifier typeKey : this.typeKeysToStructureKeys.keySet()) {
            buf.writeIdentifier(typeKey);
            List structureKeys = this.typeKeysToStructureKeys.get((Object)typeKey);
            buf.writeInt(structureKeys.size());
            for (Identifier structureKey : structureKeys) {
                buf.writeIdentifier(structureKey);
            }
        }
    }

    public static void handle(SyncPacket packet, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> {
                ExplorersCompass.canTeleport = packet.canTeleport;
                ExplorersCompass.allowedStructureKeys = packet.allowedStructureKeys;
                ExplorersCompass.dimensionKeysForAllowedStructureKeys = packet.dimensionKeysForAllowedStructureKeys;
                ExplorersCompass.structureKeysToTypeKeys = packet.structureKeysToTypeKeys;
                ExplorersCompass.typeKeysToStructureKeys = packet.typeKeysToStructureKeys;
            });
        }
    }

    public CustomPacketPayload.Type<SyncPacket> type() {
        return TYPE;
    }
}

