/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib.client.render.screen;

import baguchi.bagus_lib.client.render.book.BaguPageButton;
import baguchi.bagus_lib.client.render.book.Book;
import baguchi.bagus_lib.client.render.book.BookAccess;
import baguchi.bagus_lib.client.render.book.component.BookComponentDefinition;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ActiveTextCollector;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jspecify.annotations.Nullable;

public class BookScreen
extends Screen {
    private final Book book;
    private int pageSize;
    private int currentPage;
    private int mouseX;
    private int mouseY;
    private BaguPageButton leftButton;
    private BaguPageButton rightButton;

    public BookScreen(Book book) {
        super((Component)Component.empty());
        book.removeDisabled();
        this.book = book;
        this.currentPage = -2;
    }

    protected void init() {
        this.leftButton = (BaguPageButton)this.addRenderableWidget((GuiEventListener)new BaguPageButton(this.getBaseX(), this.getBaseY() + this.book.height(), this.book, false, true, button -> this.flipLeft()));
        this.rightButton = (BaguPageButton)this.addRenderableWidget((GuiEventListener)new BaguPageButton(this.getBaseX() + this.book.width() - this.book.buttonWidth(), this.getBaseY() + this.book.height(), this.book, true, true, button -> this.flipRight()));
        this.pageSize = 0;
        for (BookComponentDefinition definition : this.getComponents()) {
            this.pageSize += definition.component().getPageCount(this.pageSize, this.font);
        }
        this.updateVisibility();
    }

    public void mouseMoved(double d, double e) {
        super.mouseMoved(d, e);
        this.mouseX = (int)d;
        this.mouseY = (int)e;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean handleClickEvent(@Nullable ClickEvent p_425867_) {
        if (p_425867_ == null) {
            return false;
        }
        LocalPlayer localplayer = Objects.requireNonNull(this.minecraft.player, "Player not available");
        ClickEvent clickEvent = p_425867_;
        Objects.requireNonNull(clickEvent);
        ClickEvent clickEvent2 = clickEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClickEvent.ChangePage.class, ClickEvent.RunCommand.class}, (Object)clickEvent2, n)) {
            case 0: {
                ClickEvent.ChangePage changePage = (ClickEvent.ChangePage)clickEvent2;
                try {
                    int n2;
                    int i = n2 = changePage.page();
                    this.setPage(i - 1);
                    return true;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                String s;
                ClickEvent.RunCommand runCommand = (ClickEvent.RunCommand)clickEvent2;
                {
                    String string;
                    s = string = runCommand.command();
                }
                BookScreen.clickCommandAction((LocalPlayer)localplayer, (String)s, (Screen)null);
                return true;
            }
        }
        BookScreen.defaultHandleGameClickEvent((ClickEvent)p_425867_, (Minecraft)this.minecraft, (Screen)this);
        return true;
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean p_434187_) {
        double x = event.x();
        double y = event.y();
        if (this.bookOpened()) {
            ActiveTextCollector.ClickableStyleFinder activetextcollector$clickablestylefinder;
            Style style;
            if (event.button() == 0 && (style = (activetextcollector$clickablestylefinder = new ActiveTextCollector.ClickableStyleFinder(this.font, (int)event.x(), (int)event.y())).result()) != null && this.handleClickEvent(style.getClickEvent())) {
                return true;
            }
            BookComponentDefinition left = this.getCurrentComponent(true);
            BookComponentDefinition right = this.getCurrentComponent(false);
            if (left != null) {
                left.component().onClick(this.createBookAccess(true), this.font, this.getBaseX() + left.xOffsetL(), this.getBaseY() + left.yOffsetL(), (int)x, (int)y);
            }
            if (right != null) {
                right.component().onClick(this.createBookAccess(false), this.font, this.getBaseX() + this.book.width() / 2 + right.xOffsetR(), this.getBaseY() + right.yOffsetR(), (int)x, (int)y);
            }
        } else if (this.currentPage < 0) {
            if (x >= (double)((float)this.getBaseX() + (float)this.book.width() / 2.0f) && x <= (double)(this.getBaseX() + this.book.width()) && y >= (double)this.getBaseY() && y <= (double)(this.getBaseY() + this.book.height())) {
                this.setPage(0);
            }
        } else if (x >= (double)this.getBaseX() && x <= (double)((float)this.getBaseX() + (float)this.book.width() / 2.0f) && y >= (double)this.getBaseY() && y <= (double)(this.getBaseY() + this.book.height())) {
            this.setPage(this.pageSize - 1);
        }
        return super.mouseClicked(event, p_434187_);
    }

    public void tick() {
        if (this.bookOpened()) {
            BookComponentDefinition left = this.getCurrentComponent(true);
            BookComponentDefinition right = this.getCurrentComponent(false);
            if (left != null) {
                left.component().tick(this.createBookAccess(true), this.font, this.getBaseX() + left.xOffsetL(), this.getBaseY() + left.yOffsetL(), this.mouseX, this.mouseY);
            }
            if (right != null) {
                right.component().tick(this.createBookAccess(false), this.font, this.getBaseX() + this.book.width() / 2 + right.xOffsetR(), this.getBaseY() + right.yOffsetR(), this.mouseX, this.mouseY);
            }
            if (left == null || right == null || left.component() != right.component()) {
                if (left != null) {
                    left.component().singleTick(this.createBookAccess(true), this.font, this.getBaseX() + left.xOffsetL(), this.getBaseY() + left.yOffsetL(), this.mouseX, this.mouseY);
                }
                if (right != null) {
                    right.component().singleTick(this.createBookAccess(false), this.font, this.getBaseX() + this.book.width() / 2 + right.xOffsetR(), this.getBaseY() + right.yOffsetR(), this.mouseX, this.mouseY);
                }
            } else {
                left.component().singleTick(this.createBookAccess(true), this.font, this.getBaseX() + left.xOffsetL(), this.getBaseY() + left.yOffsetL(), this.mouseX, this.mouseY);
            }
        }
        this.updateVisibility();
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderBackground(guiGraphics, i, j, f);
        if (this.bookOpened()) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.book.background(), this.getBaseX(), this.getBaseY(), 0.0f, 0.0f, this.book.width(), this.book.height(), this.book.width(), this.book.height());
            BookComponentDefinition left = this.getCurrentComponent(true);
            BookComponentDefinition right = this.getCurrentComponent(false);
            if (left != null) {
                left.component().render(this.createBookAccess(true), guiGraphics, this.font, this.getBaseX() + left.xOffsetL(), this.getBaseY() + left.yOffsetL(), this.mouseX, this.mouseY);
            }
            if (right != null) {
                right.component().render(this.createBookAccess(false), guiGraphics, this.font, this.getBaseX() + this.book.width() / 2 + right.xOffsetR(), this.getBaseY() + right.yOffsetR(), this.mouseX, this.mouseY);
            }
        } else if (this.currentPage < 0) {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.book.cover(), this.getBaseX() + this.book.width() / 2, this.getBaseY(), 0.0f, 0.0f, this.book.width() / 2, this.book.height(), this.book.width() / 2, this.book.height());
        } else {
            guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.book.backCover(), this.getBaseX(), this.getBaseY(), 0.0f, 0.0f, this.book.width() / 2, this.book.height(), this.book.width() / 2, this.book.height());
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void flipLeft() {
        this.setPage(this.currentPage - 2);
        this.updateVisibility();
    }

    public void flipRight() {
        this.setPage(this.currentPage + 2);
        this.updateVisibility();
    }

    private int getBaseX() {
        return (this.width - this.book.width()) / 2;
    }

    private int getBaseY() {
        return (this.height - this.book.height()) / 2;
    }

    private boolean bookOpened() {
        return this.currentPage >= 0 && this.currentPage < this.pageSize;
    }

    @javax.annotation.Nullable
    private BookComponentDefinition getCurrentComponent(boolean left) {
        if (this.getCurrentComponentIndex(left) == -1) {
            return null;
        }
        return this.getComponents().get(this.getCurrentComponentIndex(left));
    }

    private int getCurrentComponentIndex(boolean left) {
        int pages = 0;
        for (int i = 0; i < this.getComponents().size(); ++i) {
            BookComponentDefinition definition = this.getComponents().get(i);
            if ((pages += definition.component().getPageCount(pages, this.font)) < this.currentPage + (left ? 1 : 2)) continue;
            return i;
        }
        return -1;
    }

    private BookAccess createBookAccess(final boolean left) {
        return new BookAccess(){

            @Override
            public int getRelativePage() {
                int pages = 0;
                for (int i = 0; i < this.getComponents().size(); ++i) {
                    int defCount;
                    BookComponentDefinition definition = this.getComponents().get(i);
                    if ((pages += (defCount = definition.component().getPageCount(pages, BookScreen.this.font))) < BookScreen.this.currentPage + (left ? 1 : 2)) continue;
                    return BookScreen.this.currentPage + (left ? 0 : 1) - (pages - defCount);
                }
                return 0;
            }

            @Override
            public boolean isLeftPage() {
                return left;
            }

            @Override
            public void setPage(int page) {
                BookScreen.this.setPage(page);
            }

            @Override
            public List<BookComponentDefinition> getComponents() {
                return BookScreen.this.getComponents();
            }
        };
    }

    private void setPage(int page) {
        this.currentPage = page - page % 2;
    }

    private void updateVisibility() {
        boolean visible;
        this.leftButton.visible = visible = this.bookOpened();
        this.rightButton.visible = visible;
    }

    private List<BookComponentDefinition> getComponents() {
        return this.book.components();
    }
}

