/*
 * Decompiled with CFR 0.152.
 */
package baguchi.bagus_lib;

import baguchi.bagus_lib.BagusConfigs;
import baguchi.bagus_lib.client.dialog.DialogType;
import baguchi.bagus_lib.command.DialogCommand;
import baguchi.bagus_lib.item.ModItems;
import baguchi.bagus_lib.message.CameraMessage;
import baguchi.bagus_lib.message.DialogMessage;
import baguchi.bagus_lib.message.EntityCameraMessage;
import baguchi.bagus_lib.message.RemoveAllDialogMessage;
import baguchi.bagus_lib.message.SyncBagusAnimationsMessage;
import baguchi.bagus_lib.message.SyncBagusAnimationsStopAllMessage;
import baguchi.bagus_lib.message.SyncBagusAnimationsStopMessage;
import baguchi.bagus_lib.message.SyncEntityPacketToServer;
import baguchi.bagus_lib.register.DialogRegister;
import baguchi.bagus_lib.register.ModDialogs;
import baguchi.bagus_lib.register.ModEntities;
import baguchi.bagus_lib.register.ModLootModifiers;
import baguchi.bagus_lib.register.ModSensors;
import baguchi.bagus_lib.register.ModStructureProcessorTypes;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Locale;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.Identifier;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="bagus_lib")
public class BagusLib {
    public static final String MODID = "bagus_lib";
    public static final Logger LOGGER = LogManager.getLogger((String)"bagus_lib");

    public BagusLib(IEventBus modEventBus, Dist dist, ModContainer modContainer) {
        if (dist.isClient()) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        }
        ModItems.ITEM_REGISTRY.register(modEventBus);
        ModEntities.ENTITIES_REGISTRY.register(modEventBus);
        ModStructureProcessorTypes.PROCESSOR_TYPE.register(modEventBus);
        ModLootModifiers.LOOT_MODIFIERS.register(modEventBus);
        ModSensors.SENSOR_TYPES.register(modEventBus);
        ModDialogs.DIALOG_TYPE.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::setupPackets);
        modEventBus.addListener(this::dataSetup);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BagusConfigs.COMMON_SPEC);
    }

    private void dataSetup(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(DialogRegister.REGISTRY_KEY, DialogType.DIRECT_CODEC, DialogType.DIRECT_CODEC);
    }

    public static Identifier prefix(String name) {
        return Identifier.fromNamespaceAndPath((String)MODID, (String)name.toLowerCase(Locale.ROOT));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    public void setupPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1.0.0").optional();
        registrar.playToClient(CameraMessage.TYPE, CameraMessage.STREAM_CODEC, (handler, payload) -> handler.handle((CameraMessage)handler, payload));
        registrar.playToClient(EntityCameraMessage.TYPE, EntityCameraMessage.STREAM_CODEC, (handler, payload) -> handler.handle((EntityCameraMessage)handler, payload));
        registrar.playToServer(SyncEntityPacketToServer.TYPE, SyncEntityPacketToServer.STREAM_CODEC, (handler, payload) -> handler.handle((SyncEntityPacketToServer)handler, payload));
        registrar.playToClient(DialogMessage.TYPE, DialogMessage.STREAM_CODEC, (handler, payload) -> handler.handle((DialogMessage)handler, payload));
        registrar.playToClient(RemoveAllDialogMessage.TYPE, RemoveAllDialogMessage.STREAM_CODEC, (handler, payload) -> handler.handle((RemoveAllDialogMessage)handler, payload));
        registrar.playToClient(SyncBagusAnimationsMessage.TYPE, SyncBagusAnimationsMessage.STREAM_CODEC, (handler, payload) -> handler.handle((SyncBagusAnimationsMessage)handler, payload));
        registrar.playToClient(SyncBagusAnimationsStopMessage.TYPE, SyncBagusAnimationsStopMessage.STREAM_CODEC, (handler, payload) -> handler.handle((SyncBagusAnimationsStopMessage)handler, payload));
        registrar.playToClient(SyncBagusAnimationsStopAllMessage.TYPE, SyncBagusAnimationsStopAllMessage.STREAM_CODEC, (handler, payload) -> handler.handle((SyncBagusAnimationsStopAllMessage)handler, payload));
    }

    private void registerCommands(RegisterCommandsEvent evt) {
        DialogCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher(), evt.getBuildContext());
    }
}

