/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.SkullRendererCache;
import dev.tr7zw.skinlayers.accessor.SkullModelStateAccessor;
import dev.tr7zw.skinlayers.accessor.SkullSettings;
import dev.tr7zw.transition.mc.PlayerUtil;
import dev.tr7zw.transition.mc.extending.ExtensionHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.object.skull.SkullModelBase;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.client.renderer.blockentity.state.SkullBlockRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SkullBlockRenderer.class})
public class SkullBlockEntityRendererMixin {
    private static final String LAYER_HOLDER = "3d_SKIN_LAYERS_HOLDER";

    @Inject(method={"extractRenderState(Lnet/minecraft/world/level/block/entity/SkullBlockEntity;Lnet/minecraft/client/renderer/blockentity/state/SkullBlockRenderState;FLnet/minecraft/world/phys/Vec3;Lnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;)V"}, at={@At(value="HEAD")})
    private void extractRenderState(SkullBlockEntity skullBlockEntity, SkullBlockRenderState skullBlockRenderState, float f, Vec3 vec3, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay, CallbackInfo ci) {
        Vec3 camera = Minecraft.getInstance().gameRenderer.getMainCamera().position();
        if (!SkinLayersModBase.config.enableSkulls) {
            return;
        }
        if (this.internalDistToCenterSqr(skullBlockEntity.getBlockPos(), (int)camera.x(), (int)camera.y(), (int)camera.z()) < (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            SkullRendererCache.lastSkull = (SkullSettings)skullBlockEntity;
            GameProfile gameProfile = PlayerUtil.getProfile((ResolvableProfile)skullBlockEntity.getOwnerProfile());
            if (gameProfile == null) {
                return;
            }
            Identifier textureLocation = PlayerUtil.getPlayerSkin((GameProfile)gameProfile);
            if (textureLocation != SkullRendererCache.lastSkull.getLastTexture()) {
                SkullRendererCache.lastSkull.setInitialized(false);
            }
            if (!SkullRendererCache.lastSkull.initialized() && SkullRendererCache.lastSkull.getHeadLayers() == null) {
                SkullRendererCache.lastSkull.setInitialized(true);
                SkullRendererCache.lastSkull.setLastTexture(textureLocation);
                SkinUtil.setup3dLayers(gameProfile, SkullRendererCache.lastSkull);
            }
            boolean bl = SkullRendererCache.renderNext = SkullRendererCache.lastSkull.getHeadLayers() != null;
            if (SkullRendererCache.renderNext && skullBlockRenderState instanceof ExtensionHolder) {
                ExtensionHolder extensionHolder = (ExtensionHolder)skullBlockRenderState;
                extensionHolder.setExtension((Object)LAYER_HOLDER, (Object)SkullRendererCache.lastSkull);
            }
        } else {
            SkullRendererCache.renderNext = false;
            SkullRendererCache.lastSkull = null;
        }
    }

    @Inject(method={"submit(Lnet/minecraft/client/renderer/blockentity/state/SkullBlockRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V"}, at={@At(value="HEAD")})
    private void submit(SkullBlockRenderState skullBlockRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, CallbackInfo ci) {
        if (SkullRendererCache.renderNext && skullBlockRenderState instanceof ExtensionHolder) {
            ExtensionHolder extensionHolder = (ExtensionHolder)skullBlockRenderState;
            SkullRendererCache.lastSkull = (SkullSettings)extensionHolder.getExtension((Object)LAYER_HOLDER, SkullSettings.class);
        } else {
            SkullRendererCache.lastSkull = null;
        }
    }

    @ModifyVariable(method={"submitSkull(Lnet/minecraft/core/Direction;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;ILnet/minecraft/client/model/object/skull/SkullModelBase;Lnet/minecraft/client/renderer/rendertype/RenderType;ILnet/minecraft/client/renderer/feature/ModelFeatureRenderer$CrumblingOverlay;)V"}, at=@At(value="STORE"), ordinal=0)
    private static SkullModelBase.State submitSkull(SkullModelBase.State state) {
        if (state instanceof SkullModelStateAccessor) {
            SkullModelStateAccessor accessor = (SkullModelStateAccessor)state;
            accessor.setSkullSettings(SkullRendererCache.lastSkull);
            SkullRendererCache.lastSkull = null;
        }
        return state;
    }

    private double internalDistToCenterSqr(BlockPos pos, double d, double e, double f) {
        double g = (double)pos.getX() + 0.5 - d;
        double h = (double)pos.getY() + 0.5 - e;
        double i = (double)pos.getZ() + 0.5 - f;
        return g * g + h * h + i * i;
    }
}

