/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import com.mojang.datafixers.util.Function8;
import com.mojang.datafixers.util.Function9;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;

public class StreamCodecHelper {
    public static final StreamCodec<ByteBuf, Vec3> VEC3 = new StreamCodec<ByteBuf, Vec3>(){

        public Vec3 decode(ByteBuf buffer) {
            return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }

        public void encode(ByteBuf buffer, Vec3 value) {
            buffer.writeDouble(value.x);
            buffer.writeDouble(value.y);
            buffer.writeDouble(value.z);
        }
    };
    public static final StreamCodec<ByteBuf, BlockState> BLOCKSTATE = new StreamCodec<ByteBuf, BlockState>(){

        public void encode(ByteBuf buffer, BlockState state) {
            VarInt.write((ByteBuf)buffer, (int)Block.getId((BlockState)state));
        }

        public BlockState decode(ByteBuf pBuffer) {
            return Block.stateById((int)VarInt.read((ByteBuf)pBuffer));
        }
    };

    private StreamCodecHelper() {
    }

    public static <B extends FriendlyByteBuf, T> StreamCodec<B, TagKey<T>> ofTagkey(final ResourceKey<? extends Registry<T>> registry) {
        return new StreamCodec<B, TagKey<T>>(){

            public void encode(B buffer, TagKey<T> value) {
                buffer.writeIdentifier(value.location());
            }

            public TagKey<T> decode(B buffer) {
                return TagKey.create((ResourceKey)registry, (Identifier)buffer.readIdentifier());
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec<B, V> ofNullable(final StreamCodec<B, V> streamCodec) {
        return new StreamCodec<B, V>(){

            public @Nullable V decode(B buf) {
                return buf.readBoolean() ? streamCodec.decode(buf) : null;
            }

            public void encode(B buf, @Nullable V value) {
                buf.writeBoolean(value != null);
                if (value != null) {
                    streamCodec.encode(buf, value);
                }
            }
        };
    }

    public static <B extends ByteBuf, V> StreamCodec.CodecOperation<B, V, V> nullable() {
        return StreamCodecHelper::ofNullable;
    }

    public static <B extends ByteBuf, V> StreamCodec<B, V> singleton(final Supplier<V> instantiator) {
        return new StreamCodec<B, V>(){

            public V decode(B p_320376_) {
                return instantiator.get();
            }

            public void encode(B p_320158_, V p_320396_) {
            }
        };
    }

    public static <B extends ByteBuf, T> StreamCodec<B, T> defaulting(StreamCodec<B, T> inner, T defaultVal, Predicate<T> isDefault) {
        return ByteBufCodecs.optional(inner).map(opt -> opt.orElse(defaultVal), val -> isDefault.test(val) ? Optional.empty() : Optional.of(val));
    }

    public static <B extends ByteBuf, E, V extends Collection<E>> StreamCodec<B, V> ofCollection(final StreamCodec<B, E> elementStreamCodec, final Supplier<V> instantiator) {
        return new StreamCodec<B, V>(){

            public V decode(B buf) {
                int size = buf.readInt();
                Collection collection = (Collection)instantiator.get();
                for (int i = 0; i < size; ++i) {
                    collection.add(elementStreamCodec.decode(buf));
                }
                return collection;
            }

            public void encode(B buf, V collection) {
                buf.writeInt(collection.size());
                for (Object element : collection) {
                    elementStreamCodec.encode(buf, element);
                }
            }
        };
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> ofMap(StreamCodec<? super B, K> keyStreamCodec, StreamCodec<? super B, V> valueStreamCodec, Supplier<M> instantiator) {
        return StreamCodecHelper.ofMap(keyStreamCodec, (K k) -> valueStreamCodec, instantiator);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> StreamCodec<B, M> ofMap(final StreamCodec<? super B, K> keyStreamCodec, final Function<K, StreamCodec<? super B, V>> valueStreamCodec, final Supplier<M> instantiator) {
        return new StreamCodec<B, M>(){

            public M decode(B buf) {
                int size = buf.readInt();
                Map map = (Map)instantiator.get();
                for (int i = 0; i < size; ++i) {
                    Object key = keyStreamCodec.decode(buf);
                    Object value = ((StreamCodec)valueStreamCodec.apply(key)).decode(buf);
                    map.put(key, value);
                }
                return map;
            }

            public void encode(B buf, M map) {
                buf.writeInt(map.size());
                map.forEach((k, v) -> {
                    keyStreamCodec.encode(buf, k);
                    ((StreamCodec)valueStreamCodec.apply(k)).encode(buf, v);
                });
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> pCodec1, final Function<C, T1> pGetter1, final StreamCodec<? super B, T2> pCodec2, final Function<C, T2> pGetter2, final StreamCodec<? super B, T3> pCodec3, final Function<C, T3> pGetter3, final StreamCodec<? super B, T4> pCodec4, final Function<C, T4> pGetter4, final StreamCodec<? super B, T5> pCodec5, final Function<C, T5> pGetter5, final StreamCodec<? super B, T6> pCodec6, final Function<C, T6> pGetter6, final StreamCodec<? super B, T7> pCodec7, final Function<C, T7> pGetter7, final StreamCodec<? super B, T8> pCodec8, final Function<C, T8> pGetter8, final Function8<T1, T2, T3, T4, T5, T6, T7, T8, C> pFactory) {
        return new StreamCodec<B, C>(){

            public C decode(B buffer) {
                Object t1 = pCodec1.decode(buffer);
                Object t2 = pCodec2.decode(buffer);
                Object t3 = pCodec3.decode(buffer);
                Object t4 = pCodec4.decode(buffer);
                Object t5 = pCodec5.decode(buffer);
                Object t6 = pCodec6.decode(buffer);
                Object t7 = pCodec7.decode(buffer);
                Object t8 = pCodec8.decode(buffer);
                return pFactory.apply(t1, t2, t3, t4, t5, t6, t7, t8);
            }

            public void encode(B buffer, C value) {
                pCodec1.encode(buffer, pGetter1.apply(value));
                pCodec2.encode(buffer, pGetter2.apply(value));
                pCodec3.encode(buffer, pGetter3.apply(value));
                pCodec4.encode(buffer, pGetter4.apply(value));
                pCodec5.encode(buffer, pGetter5.apply(value));
                pCodec6.encode(buffer, pGetter6.apply(value));
                pCodec7.encode(buffer, pGetter7.apply(value));
                pCodec8.encode(buffer, pGetter8.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8, T9> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> pCodec1, final Function<C, T1> pGetter1, final StreamCodec<? super B, T2> pCodec2, final Function<C, T2> pGetter2, final StreamCodec<? super B, T3> pCodec3, final Function<C, T3> pGetter3, final StreamCodec<? super B, T4> pCodec4, final Function<C, T4> pGetter4, final StreamCodec<? super B, T5> pCodec5, final Function<C, T5> pGetter5, final StreamCodec<? super B, T6> pCodec6, final Function<C, T6> pGetter6, final StreamCodec<? super B, T7> pCodec7, final Function<C, T7> pGetter7, final StreamCodec<? super B, T8> pCodec8, final Function<C, T8> pGetter8, final StreamCodec<? super B, T9> pCodec9, final Function<C, T9> pGetter9, final Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, C> pFactory) {
        return new StreamCodec<B, C>(){

            public C decode(B buffer) {
                Object t1 = pCodec1.decode(buffer);
                Object t2 = pCodec2.decode(buffer);
                Object t3 = pCodec3.decode(buffer);
                Object t4 = pCodec4.decode(buffer);
                Object t5 = pCodec5.decode(buffer);
                Object t6 = pCodec6.decode(buffer);
                Object t7 = pCodec7.decode(buffer);
                Object t8 = pCodec8.decode(buffer);
                Object t9 = pCodec9.decode(buffer);
                return pFactory.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9);
            }

            public void encode(B buffer, C value) {
                pCodec1.encode(buffer, pGetter1.apply(value));
                pCodec2.encode(buffer, pGetter2.apply(value));
                pCodec3.encode(buffer, pGetter3.apply(value));
                pCodec4.encode(buffer, pGetter4.apply(value));
                pCodec5.encode(buffer, pGetter5.apply(value));
                pCodec6.encode(buffer, pGetter6.apply(value));
                pCodec7.encode(buffer, pGetter7.apply(value));
                pCodec8.encode(buffer, pGetter8.apply(value));
                pCodec9.encode(buffer, pGetter9.apply(value));
            }
        };
    }
}

