/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.tank;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemAccessItemHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.init.ModFluids;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedTankUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IStackableContentsUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.tank.TankUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.MutableStackItemAccess;
import net.p3pp3rf1y.sophisticatedcore.util.XpHelper;
import org.jspecify.annotations.Nullable;

public class TankUpgradeWrapper
extends UpgradeWrapperBase<TankUpgradeWrapper, TankUpgradeItem>
implements IRenderedTankUpgrade,
ITickableUpgrade,
IStackableContentsUpgrade {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public static final int INPUT_RESULT_SLOT = 2;
    public static final int OUTPUT_RESULT_SLOT = 3;
    private Consumer<RenderData.TankRenderData> updateTankRenderDataCallback;
    private final TankComponentItemHandler inventory;
    private FluidStack contents;
    private long cooldownTime = 0L;
    private final Journal journal = new Journal();
    private static final Map<ItemStack, Function<ItemAccess, ResourceHandler<FluidResource>>> CUSTOM_FLUIDHANDLER_FACTORIES = Map.of(new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE), itemAccess -> new SwapEmptyFluidContainerHandler.Full((ItemAccess)itemAccess, Items.GLASS_BOTTLE, new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE), XpHelper.experienceToLiquid(8.0f), (Fluid)ModFluids.XP_STILL.get()), PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER), itemAccess -> new SwapEmptyFluidContainerHandler.Full((ItemAccess)itemAccess, Items.GLASS_BOTTLE, PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER), 250, (Fluid)Fluids.WATER), new ItemStack((ItemLike)Items.GLASS_BOTTLE), itemAccess -> new SwapEmptyFluidContainerHandler.Empty((ItemAccess)itemAccess, Items.GLASS_BOTTLE, new SwapEmptyFluidContainerHandler.FullContainerDefinition(new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE), XpHelper.experienceToLiquid(8.0f), (Fluid)ModFluids.XP_STILL.get()), new SwapEmptyFluidContainerHandler.FullContainerDefinition(PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.WATER), 250, (Fluid)Fluids.WATER)));

    protected TankUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.contents = TankUpgradeWrapper.getContents(upgrade).copy();
        if (upgrade.has(DataComponents.CONTAINER)) {
            upgrade.set(ModCoreDataComponents.LENIENT_CONTAINER, (Object)((ItemContainerContents)upgrade.get(DataComponents.CONTAINER)));
        }
        upgrade.remove(DataComponents.CONTAINER);
        this.inventory = new TankComponentItemHandler(upgrade);
    }

    public static SimpleFluidContent getContents(ItemStack upgrade) {
        return (SimpleFluidContent)upgrade.getOrDefault(ModCoreDataComponents.FLUID_CONTENTS, (Object)SimpleFluidContent.EMPTY);
    }

    private boolean isValidFluidHandler(ResourceHandler<FluidResource> fluidHandler, boolean isOutput) {
        boolean tankEmpty = this.contents.isEmpty();
        for (int tank = 0; tank < fluidHandler.size(); ++tank) {
            FluidResource fluidInTank = (FluidResource)fluidHandler.getResource(tank);
            if (isOutput && fluidHandler.getAmountAsInt(tank) < fluidHandler.getCapacityAsInt(tank, (Resource)fluidInTank) && (fluidInTank.isEmpty() || tankEmpty || fluidInTank.matches(this.contents))) {
                return true;
            }
            if (isOutput || fluidInTank.isEmpty() || !tankEmpty && !fluidInTank.matches(this.contents)) continue;
            return true;
        }
        return false;
    }

    private boolean hasNoMatchingFluid(ResourceHandler<FluidResource> fluidHandler) {
        boolean tankEmpty = this.contents.isEmpty();
        for (int tank = 0; tank < fluidHandler.size(); ++tank) {
            FluidResource fluidInTank = (FluidResource)fluidHandler.getResource(tank);
            if (!tankEmpty && fluidInTank.matches(this.contents)) {
                return false;
            }
            if (fluidInTank.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean matchingTankIsFull(ResourceHandler<FluidResource> fluidHandler) {
        boolean tankEmpty = this.contents.isEmpty();
        for (int tank = 0; tank < fluidHandler.size(); ++tank) {
            FluidResource fluidInTank = (FluidResource)fluidHandler.getResource(tank);
            int tankCapacity = fluidHandler.getCapacityAsInt(tank, (Resource)fluidInTank);
            int amount = fluidHandler.getAmountAsInt(tank);
            if (tankEmpty && amount < tankCapacity) {
                return false;
            }
            if (!fluidInTank.matches(this.contents) || amount >= tankCapacity) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setTankRenderDataUpdateCallback(Consumer<RenderData.TankRenderData> updateTankRenderDataCallback) {
        this.updateTankRenderDataCallback = updateTankRenderDataCallback;
    }

    @Override
    public void forceUpdateTankRenderData() {
        this.updateTankRenderDataCallback.accept(new RenderData.TankRenderData(this.contents.copy(), this.contents.isEmpty() ? 0.0f : (float)Math.round((float)this.contents.getAmount() / (float)this.getCapacity() * 10.0f) / 10.0f));
    }

    public FluidStack getContents() {
        return this.contents;
    }

    public FluidResource getResource() {
        return FluidResource.of((FluidStack)this.contents);
    }

    public int getAmount() {
        return this.contents.getAmount();
    }

    public int getCapacity() {
        return ((TankUpgradeItem)this.upgradeItem).getTankCapacity(this.storageWrapper);
    }

    public TankComponentItemHandler getInventory() {
        return this.inventory;
    }

    private int getMaxInOut() {
        return (int)Math.max(1000.0, (double)((Integer)((TankUpgradeItem)this.upgradeItem).getTankUpgradeConfig().maxInputOutput.get() * this.storageWrapper.getNumberOfSlotRows()) * ((TankUpgradeItem)this.upgradeItem).getAdjustedStackMultiplier(this.storageWrapper));
    }

    public int insert(FluidResource resource, int amount, TransactionContext tx, boolean ignoreInOutLimit) {
        int capacity = this.getCapacity();
        if (this.contents.getAmount() >= capacity || !this.contents.isEmpty() && !resource.matches(this.contents)) {
            return 0;
        }
        int toFill = Math.min(capacity - this.contents.getAmount(), amount);
        if (!ignoreInOutLimit) {
            toFill = Math.min(this.getMaxInOut(), toFill);
        }
        this.journal.updateSnapshots(tx);
        if (this.contents.isEmpty()) {
            this.contents = resource.toStack(toFill);
        } else {
            this.contents.setAmount(this.contents.getAmount() + toFill);
        }
        this.serializeContents();
        return toFill;
    }

    private void serializeContents() {
        this.upgrade.set(ModCoreDataComponents.FLUID_CONTENTS, (Object)SimpleFluidContent.copyOf((FluidStack)this.contents));
        this.save();
        this.forceUpdateTankRenderData();
    }

    public int extract(FluidResource resource, int maxDrain, TransactionContext tx, boolean ignoreInOutLimit) {
        if (this.contents.isEmpty() || !resource.matches(this.contents)) {
            return 0;
        }
        int toDrain = Math.min(maxDrain, this.contents.getAmount());
        if (!ignoreInOutLimit) {
            toDrain = Math.min(this.getMaxInOut(), toDrain);
        }
        this.journal.updateSnapshots(tx);
        if (toDrain == this.contents.getAmount()) {
            this.contents = FluidStack.EMPTY;
        } else {
            this.contents.setAmount(this.contents.getAmount() - toDrain);
        }
        this.serializeContents();
        return toDrain;
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        if (level.getGameTime() < this.cooldownTime) {
            return;
        }
        boolean didSomething = this.drainStack(this.inventory.getStackInSlot(0));
        if (didSomething |= this.fillStack(this.inventory.getStackInSlot(1))) {
            this.cooldownTime = level.getGameTime() + (long)((Integer)((TankUpgradeItem)this.upgradeItem).getTankUpgradeConfig().autoFillDrainContainerCooldown.get()).intValue();
        }
    }

    private boolean drainStack(ItemStack stackToDrain) {
        if (stackToDrain.isEmpty()) {
            return false;
        }
        try (Transaction tx = Transaction.openRoot();){
            MutableStackItemAccess itemAccess = new MutableStackItemAccess(stackToDrain.copyWithCount(1));
            boolean bl = this.getFluidHandler(stackToDrain, itemAccess).map(fluidHandler -> {
                if (this.drainHandler((ResourceHandler<FluidResource>)fluidHandler, (TransactionContext)tx) > 0) {
                    if (this.hasNoMatchingFluid((ResourceHandler<FluidResource>)fluidHandler)) {
                        if (this.inventory.insert(2, (Resource)itemAccess.getResource(), itemAccess.getAmount(), (TransactionContext)tx) == itemAccess.getAmount()) {
                            tx.commit();
                            this.inventory.setStackInSlot(0, stackToDrain.getCount() == 1 ? ItemStack.EMPTY : stackToDrain.copyWithCount(stackToDrain.getCount() - 1));
                            return true;
                        }
                        if (stackToDrain.getCount() > 1) {
                            return false;
                        }
                    }
                    tx.commit();
                    this.inventory.setStackInSlot(0, itemAccess.getStack());
                    return true;
                }
                return false;
            }).orElse(false);
            return bl;
        }
    }

    private Optional<ResourceHandler<FluidResource>> getFluidHandler(ItemStack stack, ItemAccess itemAccess) {
        ResourceHandler result = (ResourceHandler)stack.getCapability(Capabilities.Fluid.ITEM, (Object)itemAccess);
        if (result != null) {
            return Optional.of(result);
        }
        return TankUpgradeWrapper.getCustomFluidHandler(stack, itemAccess);
    }

    private boolean fillStack(ItemStack stackToFill) {
        if (stackToFill.isEmpty()) {
            return false;
        }
        try (Transaction tx = Transaction.openRoot();){
            MutableStackItemAccess itemAccess = new MutableStackItemAccess(stackToFill.copyWithCount(1));
            boolean bl = this.getFluidHandler(stackToFill, itemAccess).map(fluidHandler -> {
                if (this.fillHandler((ResourceHandler<FluidResource>)fluidHandler, (TransactionContext)tx) > 0) {
                    if (this.matchingTankIsFull((ResourceHandler<FluidResource>)fluidHandler)) {
                        if (this.inventory.insert(3, (Resource)itemAccess.getResource(), itemAccess.getAmount(), (TransactionContext)tx) == itemAccess.getAmount()) {
                            tx.commit();
                            this.inventory.setStackInSlot(1, stackToFill.getCount() == 1 ? ItemStack.EMPTY : stackToFill.copyWithCount(stackToFill.getCount() - 1));
                            return true;
                        }
                        if (stackToFill.getCount() > 1) {
                            return false;
                        }
                    }
                    tx.commit();
                    this.inventory.setStackInSlot(1, itemAccess.getStack());
                    return true;
                }
                return false;
            }).orElse(false);
            return bl;
        }
    }

    public void interactWithCursorStack(ItemStack cursorStack, Consumer<ItemStack> updateContainerStack) {
        MutableStackItemAccess itemAccess = new MutableStackItemAccess(cursorStack);
        this.getFluidHandler(cursorStack, itemAccess).ifPresent(fluidHandler -> {
            try (Transaction tx = Transaction.openRoot();){
                if (this.fillHandler((ResourceHandler<FluidResource>)fluidHandler, (TransactionContext)tx) > 0) {
                    updateContainerStack.accept(itemAccess.getStack());
                    tx.commit();
                } else if (this.drainHandler((ResourceHandler<FluidResource>)fluidHandler, (TransactionContext)tx) > 0) {
                    updateContainerStack.accept(itemAccess.getStack());
                    tx.commit();
                }
            }
        });
    }

    private static Optional<ResourceHandler<FluidResource>> getCustomFluidHandler(ItemStack stack, ItemAccess itemAccess) {
        return CUSTOM_FLUIDHANDLER_FACTORIES.entrySet().stream().filter(e -> ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)((ItemStack)e.getKey()))).map(e -> (ResourceHandler)((Function)e.getValue()).apply(itemAccess)).findFirst();
    }

    public int fillHandler(ResourceHandler<FluidResource> fluidHandler, TransactionContext tx) {
        if (!this.contents.isEmpty() && this.isValidFluidHandler(fluidHandler, true)) {
            FluidResource fluidResource = FluidResource.of((FluidStack)this.contents);
            int filled = fluidHandler.insert((Resource)fluidResource, Math.min(1000, this.contents.getAmount()), tx);
            if (filled <= 0) {
                return 0;
            }
            return this.extract(fluidResource, filled, tx, false);
        }
        return 0;
    }

    public int drainHandler(ResourceHandler<FluidResource> fluidHandler, TransactionContext tx) {
        if (this.isValidFluidHandler(fluidHandler, false)) {
            int extracted;
            FluidResource resource = this.contents.isEmpty() ? (FluidResource)fluidHandler.getResource(0) : FluidResource.of((FluidStack)this.contents);
            int n = extracted = this.contents.isEmpty() ? fluidHandler.extract((Resource)resource, 1000, tx) : fluidHandler.extract((Resource)FluidResource.of((FluidStack)this.contents), Math.min(1000, this.getCapacity() - this.contents.getAmount()), tx);
            if (extracted <= 0) {
                return 0;
            }
            return this.insert(resource, extracted, tx, true);
        }
        return 0;
    }

    @Override
    public int getMinimumMultiplierRequired() {
        return (int)Math.ceil((float)this.contents.getAmount() / (float)((TankUpgradeItem)this.upgradeItem).getBaseCapacity(this.storageWrapper));
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    public class Journal
    extends SnapshotJournal<FluidStack> {
        protected FluidStack createSnapshot() {
            return TankUpgradeWrapper.this.getContents().copy();
        }

        protected void revertToSnapshot(FluidStack fluidStack) {
            TankUpgradeWrapper.this.contents = fluidStack;
            TankUpgradeWrapper.this.serializeContents();
        }
    }

    public class TankComponentItemHandler
    extends ItemAccessItemHandler {
        public TankComponentItemHandler(ItemStack upgrade) {
            super(ItemAccess.forStack((ItemStack)upgrade), ModCoreDataComponents.LENIENT_CONTAINER.get(), 4);
        }

        protected ItemResource update(ItemResource accessResource, int index, ItemResource newResource, int newAmount) {
            ItemResource result = super.update(accessResource, index, newResource, newAmount);
            TankUpgradeWrapper.this.save();
            return result;
        }

        public boolean isValid(int index, ItemResource resource) {
            if (index == 0) {
                return resource.isEmpty() || this.hasValidFluidHandler(resource, false);
            }
            if (index == 1) {
                return resource.isEmpty() || this.hasValidFluidHandler(resource, true);
            }
            return index == 2 || index == 3;
        }

        private boolean hasValidFluidHandler(ItemResource resource, boolean isOutput) {
            return TankUpgradeWrapper.this.getFluidHandler(resource.toStack(), ItemAccess.forStack((ItemStack)resource.toStack())).map(fluidHandler -> TankUpgradeWrapper.this.isValidFluidHandler((ResourceHandler<FluidResource>)fluidHandler, isOutput)).orElse(false);
        }

        public ItemStack getStackInSlot(int slot) {
            ItemContainerContents contents = this.getContents(this.itemAccess.getResource());
            return this.getStackFromContents(contents, slot);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            ItemContainerContents contents = this.getContents(this.itemAccess.getResource());
            NonNullList list = NonNullList.withSize((int)Math.max(4, this.size), (Object)ItemStack.EMPTY);
            contents.copyInto(list);
            list.set(slot, (Object)stack);
            TankUpgradeWrapper.this.upgrade.set(this.component, (Object)ItemContainerContents.fromItems((List)list));
        }
    }

    private static abstract class SwapEmptyFluidContainerHandler
    implements ResourceHandler<FluidResource> {
        private final Item empty;
        private final Map<FluidStack, FullContainerDefinition> fullContainers = new HashMap<FluidStack, FullContainerDefinition>();
        private FluidStack contents;
        private final ItemAccess itemAccess;

        protected SwapEmptyFluidContainerHandler(ItemAccess itemAccess, Item empty, FluidStack contents, FullContainerDefinition ... fullContainers) {
            this.itemAccess = itemAccess;
            this.empty = empty;
            Arrays.stream(fullContainers).forEach(fc -> this.fullContainers.put(fc.validFluid, (FullContainerDefinition)fc));
            this.contents = contents;
        }

        public int size() {
            return 1;
        }

        public FluidResource getResource(int i) {
            return FluidResource.of((FluidStack)this.contents);
        }

        public long getAmountAsLong(int i) {
            return this.contents.getAmount();
        }

        public long getCapacityAsLong(int i, FluidResource resource) {
            return this.getMatchingDefinition().map(FullContainerDefinition::capacity).orElseGet(() -> this.fullContainers.values().stream().mapToInt(FullContainerDefinition::capacity).max().orElse(0)).intValue();
        }

        private Optional<FullContainerDefinition> getMatchingDefinition() {
            return this.fullContainers.entrySet().stream().filter(e -> FluidStack.isSameFluidSameComponents((FluidStack)((FluidStack)e.getKey()), (FluidStack)this.contents)).map(Map.Entry::getValue).findFirst();
        }

        public boolean isValid(int i, FluidResource resource) {
            if (!this.contents.isEmpty()) {
                return resource.matches(this.contents);
            }
            return this.fullContainers.keySet().stream().anyMatch(arg_0 -> ((FluidResource)resource).matches(arg_0));
        }

        public int insert(int index, FluidResource resource, int amount, TransactionContext tx) {
            if (!this.isValid(0, resource) || this.itemAccess.getResource().getItem() != this.empty) {
                return 0;
            }
            return this.findFirstFullContainer(resource).map(fullContainer -> {
                int result = 0;
                int capacity = fullContainer.capacity();
                if (amount >= capacity) {
                    result = capacity;
                    this.itemAccess.exchange(ItemResource.of((ItemStack)fullContainer.full()), 1, tx);
                    this.contents = resource.toStack(capacity);
                }
                return result;
            }).orElse(0);
        }

        private Optional<FullContainerDefinition> findFirstFullContainer(FluidResource resource) {
            return this.fullContainers.entrySet().stream().filter(e -> resource.matches((FluidStack)e.getKey())).findFirst().map(Map.Entry::getValue);
        }

        public int extract(FluidResource resource, int amount, TransactionContext transaction) {
            return super.extract((Resource)resource, amount, transaction);
        }

        public int extract(int index, FluidResource resource, int amount, TransactionContext tx) {
            return this.findFirstFullContainer(resource).map(fullContainer -> {
                int result = 0;
                if (this.isValid(0, resource) && amount >= fullContainer.capacity()) {
                    result = fullContainer.capacity();
                    this.itemAccess.exchange(ItemResource.of((ItemStack)new ItemStack((ItemLike)this.empty)), 1, tx);
                    this.contents = FluidStack.EMPTY;
                }
                return result;
            }).orElse(0);
        }

        private record FullContainerDefinition(ItemStack full, int capacity, FluidStack validFluid) {
            public FullContainerDefinition(ItemStack full, int capacity, Fluid validFluid) {
                this(full, capacity, new FluidStack(validFluid, capacity));
            }
        }

        public static class Full
        extends SwapEmptyFluidContainerHandler {
            public Full(ItemAccess itemAccess, Item empty, ItemStack full, int capacity, Fluid validFluid) {
                super(itemAccess, empty, new FluidStack(validFluid, capacity), new FullContainerDefinition(full, capacity, new FluidStack(validFluid, capacity)));
            }
        }

        public static class Empty
        extends SwapEmptyFluidContainerHandler {
            public Empty(ItemAccess itemAccess, Item empty, FullContainerDefinition ... fullContainers) {
                super(itemAccess, empty, FluidStack.EMPTY, fullContainers);
            }
        }
    }
}

