/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.pickup;

import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ContentsFilterLogic;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IContentsFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IPickupResponseUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.pickup.PickupUpgradeItem;

public class PickupUpgradeWrapper
extends UpgradeWrapperBase<PickupUpgradeWrapper, PickupUpgradeItem>
implements IPickupResponseUpgrade,
IContentsFilteredUpgrade {
    private final ContentsFilterLogic filterLogic;

    public PickupUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new ContentsFilterLogic(upgrade, stack -> this.save(), ((PickupUpgradeItem)this.upgradeItem).getFilterSlotCount(), storageWrapper::getInventoryHandler, storageWrapper.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class), ModCoreDataComponents.FILTER_ATTRIBUTES);
    }

    @Override
    public int pickup(Level level, ItemResource resource, int amount, TransactionContext tx) {
        if (!this.filterLogic.matchesFilter(resource)) {
            return 0;
        }
        return this.storageWrapper.getInventoryForUpgradeProcessing().insert((Resource)resource, amount, tx);
    }

    @Override
    public ContentsFilterLogic getFilterLogic() {
        return this.filterLogic;
    }
}

