/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.p3pp3rf1y.sophisticatedcore.upgrades.jukebox.JukeboxUpgradeNoteParticleData;
import org.jspecify.annotations.Nullable;

public class JukeboxUpgradeNoteParticle
extends SingleQuadParticle {
    protected JukeboxUpgradeNoteParticle(ClientLevel level, double x, double y, double z, TextureAtlasSprite sprite) {
        super(level, x, y, z, 0.0, 0.0, 0.0, sprite);
        this.xd *= (double)0.01f;
        this.yd *= (double)0.05f;
        this.zd *= (double)0.01f;
        this.yd += 0.01;
        double color = level.getRandom().nextDouble();
        this.rCol = Math.max(0.0f, Mth.sin((double)(((float)color + 0.0f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.gCol = Math.max(0.0f, Mth.sin((double)(((float)color + 0.33333334f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.bCol = Math.max(0.0f, Mth.sin((double)(((float)color + 0.6666667f) * ((float)Math.PI * 2))) * 0.65f + 0.35f);
        this.quadSize *= 1.5f;
        this.lifetime = 20;
    }

    protected SingleQuadParticle.Layer getLayer() {
        return SingleQuadParticle.Layer.OPAQUE;
    }

    public float getQuadSize(float scaleFactor) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + scaleFactor) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
            if (this.y == this.yo) {
                this.xd *= 1.1;
                this.zd *= 1.1;
            }
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
    }

    public static class Factory
    implements ParticleProvider<JukeboxUpgradeNoteParticleData> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public @Nullable Particle createParticle(JukeboxUpgradeNoteParticleData type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource randomSource) {
            return new JukeboxUpgradeNoteParticle(level, x, y, z, this.spriteSet.get(randomSource));
        }
    }
}

