/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades.battery;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.energy.EnergyHandler;
import net.neoforged.neoforge.transfer.item.ItemAccessItemHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.transaction.SnapshotJournal;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderData;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IRenderedBatteryUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IStackableContentsUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedcore.upgrades.battery.BatteryUpgradeItem;
import org.jspecify.annotations.Nullable;

public class BatteryUpgradeWrapper
extends UpgradeWrapperBase<BatteryUpgradeWrapper, BatteryUpgradeItem>
implements IRenderedBatteryUpgrade,
EnergyHandler,
ITickableUpgrade,
IStackableContentsUpgrade {
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    private Consumer<RenderData.BatteryRenderData> updateBatteryRenderDataCallback;
    private final BatteryComponentItemHandler inventory;
    private int energyStored;
    private final EnergyJournal energyJournal = new EnergyJournal();

    protected BatteryUpgradeWrapper(IStorageWrapper storageWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(storageWrapper, upgrade, upgradeSaveHandler);
        if (upgrade.has(DataComponents.CONTAINER)) {
            upgrade.set(ModCoreDataComponents.LENIENT_CONTAINER, (Object)((ItemContainerContents)upgrade.get(DataComponents.CONTAINER)));
        }
        upgrade.remove(DataComponents.CONTAINER);
        this.inventory = new BatteryComponentItemHandler(upgrade);
        this.energyStored = BatteryUpgradeWrapper.getEnergyStored(upgrade);
    }

    public static int getEnergyStored(ItemStack upgrade) {
        return (Integer)upgrade.getOrDefault(ModCoreDataComponents.ENERGY_STORED, (Object)0);
    }

    public int insert(int amount, TransactionContext tx) {
        return this.innerReceiveEnergy(amount, tx);
    }

    private int innerReceiveEnergy(int maxReceive, TransactionContext tx) {
        int ret = (int)Math.min(this.getCapacityAsLong() - (long)this.energyStored, (long)Math.min(this.getMaxInOut(), maxReceive));
        this.energyJournal.updateSnapshots(tx);
        this.energyStored += ret;
        return ret;
    }

    private void serializeEnergyStored() {
        this.upgrade.set(ModCoreDataComponents.ENERGY_STORED, (Object)this.energyStored);
        this.save();
        this.forceUpdateBatteryRenderData();
    }

    public int extract(int amount, TransactionContext tx) {
        return this.innerExtractEnergy(amount, tx);
    }

    private int innerExtractEnergy(int maxExtract, TransactionContext tx) {
        int ret = Math.min(this.energyStored, Math.min(this.getMaxInOut(), maxExtract));
        this.energyJournal.updateSnapshots(tx);
        this.energyStored -= ret;
        return ret;
    }

    public long getAmountAsLong() {
        return this.energyStored;
    }

    public long getCapacityAsLong() {
        return ((BatteryUpgradeItem)this.upgradeItem).getMaxEnergyStored(this.storageWrapper);
    }

    private int getMaxInOut() {
        int baseInOut;
        double stackMultiplier = ((BatteryUpgradeItem)this.upgradeItem).getAdjustedStackMultiplier(this.storageWrapper);
        return stackMultiplier > 2.147483647E9 / (double)(baseInOut = (Integer)((BatteryUpgradeItem)this.upgradeItem).getBatteryUpgradeConfig().maxInputOutput.get() * this.storageWrapper.getNumberOfSlotRows()) ? Integer.MAX_VALUE : (int)((double)baseInOut * stackMultiplier);
    }

    @Override
    public void setBatteryRenderDataUpdateCallback(Consumer<RenderData.BatteryRenderData> updateBatteryRenderDataCallback) {
        this.updateBatteryRenderDataCallback = updateBatteryRenderDataCallback;
    }

    @Override
    public void forceUpdateBatteryRenderData() {
        RenderData.BatteryRenderData batteryRenderData = new RenderData.BatteryRenderData(Mth.clamp((float)((float)this.energyStored / (float)this.getCapacityAsLong()), (float)0.0f, (float)1.0f));
        this.updateBatteryRenderDataCallback.accept(batteryRenderData);
    }

    @Override
    public void tick(@Nullable Entity entity, Level level, BlockPos pos) {
        EnergyHandler energyStorage;
        ItemAccess itemAccess;
        EnergyHandler energyHandler;
        ItemStack energyContainer;
        if ((long)this.energyStored < this.getCapacityAsLong() && !(energyContainer = this.inventory.getStackInSlot(0)).isEmpty() && (energyHandler = (EnergyHandler)(itemAccess = ItemAccess.forStack((ItemStack)energyContainer)).getCapability(Capabilities.Energy.ITEM)) != null) {
            this.receiveFromStorage(energyContainer, energyHandler);
        }
        if (this.energyStored > 0 && !(energyContainer = this.inventory.getStackInSlot(1)).isEmpty() && (energyStorage = (EnergyHandler)(itemAccess = ItemAccess.forStack((ItemStack)energyContainer)).getCapability(Capabilities.Energy.ITEM)) != null) {
            this.extractToStorage(energyContainer, energyStorage);
        }
    }

    private void extractToStorage(ItemStack energyContainer, EnergyHandler energyStorage) {
        try (Transaction tx = Transaction.openRoot();){
            int maxToInsert = Math.min(this.energyStored, this.getMaxInOut());
            int inserted = energyStorage.insert(maxToInsert, (TransactionContext)tx);
            if (inserted > 0) {
                this.extract(inserted, (TransactionContext)tx);
                this.inventory.setStackInSlot(1, energyContainer);
                tx.commit();
            }
        }
    }

    private void receiveFromStorage(ItemStack energyContainer, EnergyHandler energyStorage) {
        try (Transaction tx = Transaction.openRoot();){
            int toReceive = (int)Math.min(this.getCapacityAsLong() - (long)this.energyStored, (long)this.getMaxInOut());
            int received = energyStorage.extract(toReceive, (TransactionContext)tx);
            if (received > 0) {
                this.innerReceiveEnergy(toReceive, (TransactionContext)tx);
                this.inventory.setStackInSlot(0, energyContainer);
                tx.commit();
            }
        }
    }

    public ResourceHandler<ItemResource> getInventory() {
        return this.inventory;
    }

    @Override
    public int getMinimumMultiplierRequired() {
        return (int)Math.ceil((float)this.energyStored / (float)((BatteryUpgradeItem)this.upgradeItem).getMaxEnergyBase(this.storageWrapper));
    }

    @Override
    public boolean canBeDisabled() {
        return false;
    }

    private class EnergyJournal
    extends SnapshotJournal<Integer> {
        private EnergyJournal() {
        }

        protected Integer createSnapshot() {
            return BatteryUpgradeWrapper.this.energyStored;
        }

        protected void revertToSnapshot(Integer snapshot) {
            BatteryUpgradeWrapper.this.energyStored = snapshot;
        }

        protected void onRootCommit(Integer originalState) {
            int previousAmount = originalState;
            if (BatteryUpgradeWrapper.this.energyStored != previousAmount) {
                BatteryUpgradeWrapper.this.serializeEnergyStored();
            }
        }
    }

    private class BatteryComponentItemHandler
    extends ItemAccessItemHandler {
        private final ItemStack upgrade;

        public BatteryComponentItemHandler(ItemStack upgrade) {
            super(ItemAccess.forStack((ItemStack)upgrade), ModCoreDataComponents.LENIENT_CONTAINER.get(), 2);
            this.upgrade = upgrade;
        }

        protected ItemResource update(ItemResource accessResource, int index, ItemResource newResource, int newAmount) {
            ItemResource result = super.update(accessResource, index, newResource, newAmount);
            BatteryUpgradeWrapper.this.save();
            return result;
        }

        public boolean isValid(int slot, ItemResource resource) {
            return this.isEnergyHandler(ItemAccess.forHandlerIndex((ResourceHandler)this, (int)slot));
        }

        private boolean isEnergyHandler(ItemAccess itemAccess) {
            return itemAccess.getCapability(Capabilities.Energy.ITEM) != null;
        }

        public ItemStack getStackInSlot(int slot) {
            ItemContainerContents contents = this.getContents(this.itemAccess.getResource());
            return this.getStackFromContents(contents, slot);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            ItemContainerContents contents = this.getContents(this.itemAccess.getResource());
            NonNullList list = NonNullList.withSize((int)Math.max(contents.getSlots(), this.size), (Object)ItemStack.EMPTY);
            contents.copyInto(list);
            list.set(slot, (Object)stack);
            this.upgrade.set(this.component, (Object)ItemContainerContents.fromItems((List)list));
        }

        protected int getCapacity(int index, ItemResource resource) {
            return 1;
        }
    }
}

