/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.nosort;

import java.util.Optional;
import java.util.Set;
import net.minecraft.world.item.DyeColor;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.ISlotColorCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategoryData;

public class NoSortSettingsCategory
implements ISettingsCategory<NoSortSettingsCategory, NoSortSettingsCategoryData>,
ISlotColorCategory {
    public static final String NAME = "no_sort";
    private final Runnable save;
    private NoSortSettingsCategoryData data;

    public NoSortSettingsCategory(NoSortSettingsCategoryData data, Runnable save) {
        this.data = data;
        this.save = save;
    }

    public boolean isSlotSelected(int slotNumber) {
        return this.data.selectedSlots().contains(slotNumber);
    }

    public void unselectAllSlots() {
        this.data.clearSelectedSlots();
        this.save();
    }

    public void selectSlots(int minSlot, int maxSlot) {
        for (int slot = minSlot; slot < maxSlot; ++slot) {
            this.data.addSelectedSlot(slot);
        }
        this.save();
    }

    public void selectSlot(int slotNumber) {
        this.selectSlots(slotNumber, slotNumber + 1);
    }

    public void unselectSlot(int slotNumber) {
        this.data.removeSelectedSlot(slotNumber);
        this.save();
    }

    private void save() {
        this.save.run();
    }

    public void setColor(DyeColor color) {
        this.data.setColor(color);
        this.save();
    }

    public DyeColor getColor() {
        return this.data.color();
    }

    @Override
    public Optional<Integer> getSlotColor(int slotNumber) {
        return this.data.selectedSlots().contains(slotNumber) ? Optional.of(this.data.color().getTextureDiffuseColor()) : Optional.empty();
    }

    public Set<Integer> getNoSortSlots() {
        return this.data.selectedSlots();
    }

    @Override
    public void reloadFrom(NoSortSettingsCategoryData data) {
        this.data = data;
    }

    @Override
    public void overwriteWith(NoSortSettingsCategory otherCategory) {
        this.data.clearSelectedSlots();
        this.data.addSelectedSlots(otherCategory.getNoSortSlots());
        this.data.setColor(otherCategory.getColor());
        this.save();
    }

    @Override
    public boolean isLargerThanNumberOfSlots(int slots) {
        return this.data.selectedSlots().stream().anyMatch(slotIndex -> slotIndex >= slots);
    }

    @Override
    public void copyTo(NoSortSettingsCategory otherCategory, int startFromSlot, int slotOffset) {
        this.data.selectedSlots().forEach(slotIndex -> {
            if (slotIndex < startFromSlot) {
                return;
            }
            otherCategory.data.addSelectedSlot(slotIndex + slotOffset);
        });
        otherCategory.save();
    }

    @Override
    public void deleteSlotSettingsFrom(int slotIndex) {
        this.data.removeSelectedSlotAtOrAfter(slotIndex);
        this.save();
    }
}

