/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings.main;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategoryData;
import net.p3pp3rf1y.sophisticatedcore.util.CodecHelper;

public final class PlayerMainSettingsSavedData
extends SavedData {
    public static final String FILE_ID = "sophisticatedcore-player-main-settings";
    private static final SavedDataType<PlayerMainSettingsSavedData> TYPE = new SavedDataType("sophisticatedcore-player-main-settings", PlayerMainSettingsSavedData::new, RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap(CodecHelper.STRING_ENCODED_UUID, (Codec)Codec.unboundedMap((Codec)Codec.STRING, MainSettingsCategoryData.CODEC).xmap(CodecHelper::toMutable, Function.identity())).xmap(CodecHelper::toMutable, Function.identity()).fieldOf("data").forGetter(savedData -> savedData.data)).apply((Applicative)instance, PlayerMainSettingsSavedData::new)));
    private static final PlayerMainSettingsSavedData clientDataCopy = new PlayerMainSettingsSavedData();
    private final Map<UUID, Map<String, MainSettingsCategoryData>> data;

    public PlayerMainSettingsSavedData(Map<UUID, Map<String, MainSettingsCategoryData>> data) {
        this.data = data;
    }

    private PlayerMainSettingsSavedData() {
        this.data = new HashMap<UUID, Map<String, MainSettingsCategoryData>>();
    }

    public static PlayerMainSettingsSavedData get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            return (PlayerMainSettingsSavedData)storage.computeIfAbsent(TYPE);
        }
        return clientDataCopy;
    }

    public MainSettingsCategoryData get(UUID uuid, String settingsName) {
        return this.data.computeIfAbsent(uuid, id -> new HashMap()).computeIfAbsent(settingsName, n -> new MainSettingsCategoryData());
    }

    public void put(UUID uuid, String settingsName, MainSettingsCategoryData value) {
        this.data.computeIfAbsent(uuid, k -> new HashMap()).put(settingsName, value);
        this.setDirty();
    }

    public void setvalue(UUID uuid, String settingsName, Consumer<MainSettingsCategoryData> setter) {
        setter.accept(this.get(uuid, settingsName));
        this.setDirty();
    }
}

