/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.p3pp3rf1y.sophisticatedcore.inventory.ContainerContents;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderDataHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.main.Context;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsCategoryData;
import net.p3pp3rf1y.sophisticatedcore.settings.main.PlayerMainSettingsSavedData;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategoryData;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategoryData;

public abstract class SettingsHandler {
    private final String playerSettingsName;
    protected ContainerContents.SettingsData settingsData;
    protected final Runnable markContentsDirty;
    protected final Map<String, ISettingsCategory<?, ?>> settingsCategories = new LinkedHashMap();
    private final Map<Class<?>, List<?>> interfaceCategories = new HashMap();
    private final Map<Class<? extends ISettingsCategory<?, ?>>, ISettingsCategory<?, ?>> typeCategories = new HashMap();

    protected SettingsHandler(ContainerContents.SettingsData settingsData, Runnable markContentsDirty, Supplier<InventoryHandler> inventoryHandlerSupplier, Supplier<RenderDataHandler> renderDataHandlerSupplier, String playerSettingsName) {
        this.settingsData = settingsData;
        this.markContentsDirty = markContentsDirty;
        this.playerSettingsName = playerSettingsName;
        this.addSettingsCategories(inventoryHandlerSupplier, renderDataHandlerSupplier, settingsData, playerSettingsName);
    }

    public String getPlayerSettingsName() {
        return this.playerSettingsName;
    }

    private void addSettingsCategories(Supplier<InventoryHandler> inventoryHandlerSupplier, Supplier<RenderDataHandler> renderDataHandlerSupplier, ContainerContents.SettingsData settingsData, String playerSettingsName) {
        this.addSettingsCategory(settingsData, "global", this.markContentsDirty, (data, save) -> new MainSettingsCategory(settingsData, (MainSettingsCategoryData)data, (Runnable)save, playerSettingsName), MainSettingsCategoryData::new);
        this.addSettingsCategory(settingsData, "no_sort", this.markContentsDirty, NoSortSettingsCategory::new, NoSortSettingsCategoryData::new);
        this.addSettingsCategory(settingsData, "memory", this.markContentsDirty, (data, save) -> new MemorySettingsCategory(inventoryHandlerSupplier, (MemorySettingsCategoryData)data, (Runnable)save), MemorySettingsCategoryData::new);
        this.addItemDisplayCategory(inventoryHandlerSupplier, renderDataHandlerSupplier, settingsData);
    }

    protected abstract void addItemDisplayCategory(Supplier<InventoryHandler> var1, Supplier<RenderDataHandler> var2, ContainerContents.SettingsData var3);

    protected <D extends ContainerContents.ISettingsCategoryData<D>, T extends ISettingsCategory<T, D>> void addSettingsCategory(ContainerContents.SettingsData settingsData, String categoryName, Runnable markContentsDirty, BiFunction<D, Runnable, T> instantiateCategory, Supplier<D> defaultDataSupplier) {
        ISettingsCategory category = (ISettingsCategory)instantiateCategory.apply(SettingsHandler.getSettingsCategoryData(settingsData, categoryName, defaultDataSupplier), markContentsDirty);
        this.settingsCategories.put(categoryName, category);
        this.typeCategories.put(category.getClass(), category);
    }

    private static <D extends ContainerContents.ISettingsCategoryData<D>> D getSettingsCategoryData(ContainerContents.SettingsData settingsData, String categoryName, Supplier<D> defaultDataSupplier) {
        return (D)settingsData.categories().computeIfAbsent(categoryName, name -> (ContainerContents.ISettingsCategoryData)defaultDataSupplier.get());
    }

    public Map<String, ISettingsCategory<?, ?>> getSettingsCategories() {
        return this.settingsCategories;
    }

    public <T> List<T> getCategoriesThatImplement(Class<T> categoryClass) {
        return this.interfaceCategories.computeIfAbsent(categoryClass, this::getListOfWrappersThatImplement);
    }

    public <T extends ISettingsCategory<?, ?>> T getTypeCategory(Class<T> categoryClazz) {
        return (T)this.typeCategories.get(categoryClazz);
    }

    private <T> List<T> getListOfWrappersThatImplement(Class<T> uc) {
        ArrayList ret = new ArrayList();
        for (ISettingsCategory<?, ?> category : this.settingsCategories.values()) {
            if (!uc.isInstance(category)) continue;
            ret.add(category);
        }
        return ret;
    }

    public ContainerContents.SettingsData getSettingsData() {
        return this.settingsData;
    }

    public void setSearchPhrase(String searchPhrase) {
        this.settingsData.setSearchPhrase(searchPhrase);
        this.markContentsDirty.run();
    }

    public void reloadFrom(ContainerContents.SettingsData settingsData) {
        this.settingsData = settingsData;
        this.getSettingsCategories().forEach((categoryName, category) -> {
            ContainerContents.ISettingsCategoryData<?> data = settingsData.categories().get(categoryName);
            if (data != null) {
                SettingsHandler.reloadFrom(category, data);
            }
        });
    }

    private static <D extends ContainerContents.ISettingsCategoryData<D>> void reloadFrom(ISettingsCategory<?, D> category, ContainerContents.ISettingsCategoryData<?> data) {
        category.reloadFrom(data);
    }

    public <S> S getMainSettingValue(Player player, Function<MainSettingsCategoryData, S> getter) {
        MainSettingsCategory mainSettings = this.getTypeCategory(MainSettingsCategory.class);
        if (mainSettings.getContext() == Context.PLAYER) {
            return getter.apply(PlayerMainSettingsSavedData.get().get(player.getUUID(), mainSettings.getPlayerSettingsName()));
        }
        return mainSettings.getValue(getter);
    }
}

